/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.observation.conventions.VectorStoreProvider;
import org.springframework.ai.observation.conventions.VectorStoreSimilarityMetric;
import org.springframework.ai.util.JacksonUtils;
import org.springframework.ai.vectorstore.AbstractVectorStoreBuilder;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.SimpleVectorStoreContent;
import org.springframework.ai.vectorstore.filter.FilterExpressionConverter;
import org.springframework.ai.vectorstore.filter.converter.SimpleVectorStoreFilterExpressionConverter;
import org.springframework.ai.vectorstore.observation.AbstractObservationVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.core.io.Resource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SimpleVectorStore
extends AbstractObservationVectorStore {
    private static final Logger logger = LoggerFactory.getLogger(SimpleVectorStore.class);
    private final ObjectMapper objectMapper;
    private final ExpressionParser expressionParser;
    private final FilterExpressionConverter filterExpressionConverter;
    protected Map<String, SimpleVectorStoreContent> store = new ConcurrentHashMap<String, SimpleVectorStoreContent>();

    protected SimpleVectorStore(SimpleVectorStoreBuilder builder) {
        super(builder);
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().addModules((Iterable)JacksonUtils.instantiateAvailableModules())).build();
        this.expressionParser = new SpelExpressionParser();
        this.filterExpressionConverter = new SimpleVectorStoreFilterExpressionConverter();
    }

    public static SimpleVectorStoreBuilder builder(EmbeddingModel embeddingModel) {
        return new SimpleVectorStoreBuilder(embeddingModel);
    }

    @Override
    public void doAdd(List<Document> documents) {
        Objects.requireNonNull(documents, "Documents list cannot be null");
        if (documents.isEmpty()) {
            throw new IllegalArgumentException("Documents list cannot be empty");
        }
        for (Document document : documents) {
            logger.info("Calling EmbeddingModel for document id = {}", (Object)document.getId());
            float[] embedding = this.embeddingModel.embed(document);
            SimpleVectorStoreContent storeContent = new SimpleVectorStoreContent(document.getId(), document.getText(), document.getMetadata(), embedding);
            this.store.put(document.getId(), storeContent);
        }
    }

    @Override
    public void doDelete(List<String> idList) {
        for (String id : idList) {
            this.store.remove(id);
        }
    }

    @Override
    public List<Document> doSimilaritySearch(SearchRequest request) {
        Predicate<SimpleVectorStoreContent> documentFilterPredicate = this.doFilterPredicate(request);
        float[] userQueryEmbedding = this.getUserQueryEmbedding(request.getQuery());
        return this.store.values().stream().filter(documentFilterPredicate).map(content -> content.toDocument(EmbeddingMath.cosineSimilarity(userQueryEmbedding, content.getEmbedding()))).filter(document -> document.getScore() >= request.getSimilarityThreshold()).sorted(Comparator.comparing(Document::getScore).reversed()).limit(request.getTopK()).toList();
    }

    private Predicate<SimpleVectorStoreContent> doFilterPredicate(SearchRequest request) {
        return request.hasFilterExpression() ? document -> {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("metadata", document.getMetadata());
            return (Boolean)this.expressionParser.parseExpression(this.filterExpressionConverter.convertExpression(request.getFilterExpression())).getValue((EvaluationContext)context, Boolean.class);
        } : document -> true;
    }

    public void save(File file) {
        String json = this.getVectorDbAsJson();
        try {
            if (!file.exists()) {
                logger.info("Creating new vector store file: {}", (Object)file);
                try {
                    Files.createFile(file.toPath(), new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException e) {
                    throw new RuntimeException("File already exists: " + String.valueOf(file), e);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create new file: " + String.valueOf(file) + ". Reason: " + e.getMessage(), e);
                }
            } else {
                logger.info("Overwriting existing vector store file: {}", (Object)file);
            }
            try (FileOutputStream stream = new FileOutputStream(file);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
                writer.write(json);
                ((Writer)writer).flush();
            }
        }
        catch (IOException ex) {
            logger.error("IOException occurred while saving vector store file.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            logger.error("SecurityException occurred while saving vector store file.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (NullPointerException ex) {
            logger.error("NullPointerException occurred while saving vector store file.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void load(File file) {
        TypeReference<HashMap<String, SimpleVectorStoreContent>> typeRef = new TypeReference<HashMap<String, SimpleVectorStoreContent>>(){};
        try {
            this.store = (Map)this.objectMapper.readValue(file, (TypeReference)typeRef);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void load(Resource resource) {
        TypeReference<HashMap<String, SimpleVectorStoreContent>> typeRef = new TypeReference<HashMap<String, SimpleVectorStoreContent>>(){};
        try {
            this.store = (Map)this.objectMapper.readValue(resource.getInputStream(), (TypeReference)typeRef);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getVectorDbAsJson() {
        ObjectWriter objectWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
        try {
            return objectWriter.writeValueAsString(this.store);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error serializing documentMap to JSON.", e);
        }
    }

    private float[] getUserQueryEmbedding(String query) {
        return this.embeddingModel.embed(query);
    }

    @Override
    public VectorStoreObservationContext.Builder createObservationContextBuilder(String operationName) {
        return VectorStoreObservationContext.builder(VectorStoreProvider.SIMPLE.value(), operationName).dimensions(this.embeddingModel.dimensions()).collectionName("in-memory-map").similarityMetric(VectorStoreSimilarityMetric.COSINE.value());
    }

    public static final class SimpleVectorStoreBuilder
    extends AbstractVectorStoreBuilder<SimpleVectorStoreBuilder> {
        private SimpleVectorStoreBuilder(EmbeddingModel embeddingModel) {
            super(embeddingModel);
        }

        @Override
        public SimpleVectorStore build() {
            return new SimpleVectorStore(this);
        }
    }

    public static final class EmbeddingMath {
        private EmbeddingMath() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static double cosineSimilarity(float[] vectorX, float[] vectorY) {
            if (vectorX == null || vectorY == null) {
                throw new RuntimeException("Vectors must not be null");
            }
            if (vectorX.length != vectorY.length) {
                throw new IllegalArgumentException("Vectors lengths must be equal");
            }
            float dotProduct = EmbeddingMath.dotProduct(vectorX, vectorY);
            float normX = EmbeddingMath.norm(vectorX);
            float normY = EmbeddingMath.norm(vectorY);
            if (normX == 0.0f || normY == 0.0f) {
                throw new IllegalArgumentException("Vectors cannot have zero norm");
            }
            return (double)dotProduct / (Math.sqrt(normX) * Math.sqrt(normY));
        }

        public static float dotProduct(float[] vectorX, float[] vectorY) {
            if (vectorX.length != vectorY.length) {
                throw new IllegalArgumentException("Vectors lengths must be equal");
            }
            float result = 0.0f;
            for (int i = 0; i < vectorX.length; ++i) {
                result += vectorX[i] * vectorY[i];
            }
            return result;
        }

        public static float norm(float[] vector) {
            return EmbeddingMath.dotProduct(vector, vector);
        }
    }
}

