/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore;

import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import java.util.Optional;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentWriter;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface VectorStore
extends DocumentWriter {
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public void add(List<Document> var1);

    default public void accept(List<Document> documents) {
        this.add(documents);
    }

    public void delete(List<String> var1);

    public void delete(Filter.Expression var1);

    default public void delete(String filterExpression) {
        SearchRequest searchRequest = SearchRequest.builder().filterExpression(filterExpression).build();
        Filter.Expression textExpression = searchRequest.getFilterExpression();
        Assert.notNull((Object)textExpression, (String)"Filter expression must not be null");
        this.delete(textExpression);
    }

    @Nullable
    public List<Document> similaritySearch(SearchRequest var1);

    @Nullable
    default public List<Document> similaritySearch(String query) {
        return this.similaritySearch(SearchRequest.builder().query(query).build());
    }

    default public <T> Optional<T> getNativeClient() {
        return Optional.empty();
    }

    public static interface Builder<T extends Builder<T>> {
        public T observationRegistry(ObservationRegistry var1);

        public T customObservationConvention(VectorStoreObservationConvention var1);

        public T batchingStrategy(BatchingStrategy var1);

        public VectorStore build();
    }
}

