/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.filter;

import java.util.List;
import org.springframework.ai.vectorstore.filter.Filter;

public class FilterExpressionBuilder {
    public Op eq(String key, Object value) {
        return new Op(new Filter.Expression(Filter.ExpressionType.EQ, new Filter.Key(key), new Filter.Value(value)));
    }

    public Op ne(String key, Object value) {
        return new Op(new Filter.Expression(Filter.ExpressionType.NE, new Filter.Key(key), new Filter.Value(value)));
    }

    public Op gt(String key, Object value) {
        return new Op(new Filter.Expression(Filter.ExpressionType.GT, new Filter.Key(key), new Filter.Value(value)));
    }

    public Op gte(String key, Object value) {
        return new Op(new Filter.Expression(Filter.ExpressionType.GTE, new Filter.Key(key), new Filter.Value(value)));
    }

    public Op lt(String key, Object value) {
        return new Op(new Filter.Expression(Filter.ExpressionType.LT, new Filter.Key(key), new Filter.Value(value)));
    }

    public Op lte(String key, Object value) {
        return new Op(new Filter.Expression(Filter.ExpressionType.LTE, new Filter.Key(key), new Filter.Value(value)));
    }

    public Op and(Op left, Op right) {
        return new Op(new Filter.Expression(Filter.ExpressionType.AND, left.expression, right.expression));
    }

    public Op or(Op left, Op right) {
        return new Op(new Filter.Expression(Filter.ExpressionType.OR, left.expression, right.expression));
    }

    public Op in(String key, Object ... values) {
        return this.in(key, List.of(values));
    }

    public Op in(String key, List<Object> values) {
        return new Op(new Filter.Expression(Filter.ExpressionType.IN, new Filter.Key(key), new Filter.Value(values)));
    }

    public Op nin(String key, Object ... values) {
        return this.nin(key, List.of(values));
    }

    public Op nin(String key, List<Object> values) {
        return new Op(new Filter.Expression(Filter.ExpressionType.NIN, new Filter.Key(key), new Filter.Value(values)));
    }

    public Op group(Op content) {
        return new Op(new Filter.Group(content.build()));
    }

    public Op not(Op content) {
        return new Op(new Filter.Expression(Filter.ExpressionType.NOT, content.expression, null));
    }

    public record Op(Filter.Operand expression) {
        public Filter.Expression build() {
            Filter.Operand operand = this.expression;
            if (operand instanceof Filter.Group) {
                Filter.Group group = (Filter.Group)operand;
                return group.content();
            }
            operand = this.expression;
            if (operand instanceof Filter.Expression) {
                Filter.Expression exp = (Filter.Expression)operand;
                return exp;
            }
            throw new RuntimeException("Invalid expression: " + String.valueOf(this.expression));
        }
    }
}

