/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.observation.ObservabilityHelper;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.util.CollectionUtils;

public class VectorStoreQueryResponseObservationHandler
implements ObservationHandler<VectorStoreObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(VectorStoreQueryResponseObservationHandler.class);

    public void onStop(VectorStoreObservationContext context) {
        logger.info("Vector Store Query Response:\n{}", (Object)ObservabilityHelper.concatenateStrings(this.documents(context)));
    }

    private List<String> documents(VectorStoreObservationContext context) {
        if (CollectionUtils.isEmpty(context.getQueryResponse())) {
            return List.of();
        }
        return context.getQueryResponse().stream().map(Document::getText).toList();
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof VectorStoreObservationContext;
    }
}

