/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

@Deprecated
final class SpanSubscriber<T>
extends AtomicBoolean
implements SpanSubscription<T> {
    private static final Logger log = Loggers.getLogger(SpanSubscriber.class);
    private final Span span;
    private final Span rootSpan;
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final Tracer tracer;
    private Subscription s;

    SpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracing tracing, String name) {
        this.subscriber = subscriber;
        this.tracer = tracing.tracer();
        Span root = (Span)ctx.getOrDefault(Span.class, (Object)this.tracer.currentSpan());
        if (log.isTraceEnabled()) {
            log.trace("Span from context [{}]", new Object[]{root});
        }
        this.rootSpan = root;
        if (log.isTraceEnabled()) {
            log.trace("Stored context root span [{}]", new Object[]{this.rootSpan});
        }
        Span span = this.span = root != null ? this.tracer.nextSpan(TraceContextOrSamplingFlags.create((TraceContext)root.context())).name(name) : this.tracer.nextSpan().name(name);
        if (log.isTraceEnabled()) {
            log.trace("Created span [{}], with name [{}]", new Object[]{this.span, name});
        }
        this.context = ctx.put(Span.class, (Object)this.span);
    }

    public void onSubscribe(Subscription subscription) {
        if (log.isTraceEnabled()) {
            log.trace("On subscribe");
        }
        this.s = subscription;
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
            if (log.isTraceEnabled()) {
                log.trace("On subscribe - span continued");
            }
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        if (log.isTraceEnabled()) {
            log.trace("Request");
        }
        try (Tracer.SpanInScope ws = this.tracer.withSpanInScope(this.span);){
            if (log.isTraceEnabled()) {
                log.trace("Request - continued");
            }
            this.s.request(n);
            if (log.isTraceEnabled()) {
                log.trace("Request after cleaning. Current span [{}]", new Object[]{this.tracer.currentSpan()});
            }
        }
    }

    public void cancel() {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Cancel");
            }
            this.s.cancel();
        }
        finally {
            this.cleanup();
        }
    }

    public void onNext(T o) {
        this.subscriber.onNext(o);
    }

    public void onError(Throwable throwable) {
        try {
            this.subscriber.onError(throwable);
        }
        finally {
            this.cleanup();
        }
    }

    public void onComplete() {
        try {
            this.subscriber.onComplete();
        }
        finally {
            this.cleanup();
        }
    }

    void cleanup() {
        if (this.compareAndSet(false, true)) {
            if (log.isTraceEnabled()) {
                log.trace("Cleaning up");
            }
            this.span.finish();
            if (log.isTraceEnabled()) {
                log.trace("Span closed");
            }
            if (this.rootSpan != null) {
                this.rootSpan.finish();
                if (log.isTraceEnabled()) {
                    log.trace("Closed root span");
                }
            }
        }
    }

    public Context currentContext() {
        return this.context;
    }
}

