/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.EndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.SingleSkipPattern;
import org.springframework.cloud.sleuth.instrument.web.SkipPatternProvider;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
@EnableConfigurationProperties(value={SleuthWebProperties.class})
public class TraceWebAutoConfiguration {
    @Autowired(required=false)
    List<SingleSkipPattern> patterns = new ArrayList<SingleSkipPattern>();

    @Bean
    @ConditionalOnMissingBean
    SkipPatternProvider sleuthSkipPatternProvider() {
        return () -> {
            StringJoiner joiner = new StringJoiner("|");
            for (SingleSkipPattern pattern : this.patterns) {
                Optional<Pattern> skipPattern = pattern.skipPattern();
                if (!skipPattern.isPresent()) continue;
                Pattern pattern1 = skipPattern.get();
                String s = pattern1.pattern();
                joiner.add(s);
            }
            return Pattern.compile(joiner.toString());
        };
    }

    @Configuration(proxyBeanMethods=false)
    static class DefaultSkipPatternConfig {
        DefaultSkipPatternConfig() {
        }

        private static String combinedPattern(String skipPattern, String additionalSkipPattern) {
            String pattern = skipPattern;
            if (!StringUtils.hasText((String)skipPattern)) {
                pattern = "/api-docs.*|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream";
            }
            if (StringUtils.hasText((String)additionalSkipPattern)) {
                return pattern + "|" + additionalSkipPattern;
            }
            return pattern;
        }

        @Bean
        SingleSkipPattern defaultSkipPatternBean(SleuthWebProperties sleuthWebProperties) {
            return () -> Optional.of(Pattern.compile(DefaultSkipPatternConfig.combinedPattern(sleuthWebProperties.getSkipPattern(), sleuthWebProperties.getAdditionalSkipPattern())));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ServerProperties.class, EndpointsSupplier.class, ExposableWebEndpoint.class})
    @ConditionalOnBean(value={ServerProperties.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.ignoreAutoConfiguredSkipPatterns"}, havingValue="false", matchIfMissing=true)
    protected static class ActuatorSkipPatternProviderConfig {
        protected ActuatorSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getEndpointsPatterns(String contextPath, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            Collection endpoints = endpointsSupplier.getEndpoints();
            if (endpoints.isEmpty()) {
                return Optional.empty();
            }
            String basePath = webEndpointProperties.getBasePath();
            String pattern = ActuatorSkipPatternProviderConfig.patternFromEndpoints(contextPath, endpoints, basePath);
            if (StringUtils.hasText((String)pattern)) {
                return Optional.of(Pattern.compile(pattern));
            }
            return Optional.empty();
        }

        private static String patternFromEndpoints(String contextPath, Collection<ExposableWebEndpoint> endpoints, String basePath) {
            StringJoiner joiner = new StringJoiner("|", ActuatorSkipPatternProviderConfig.getPathPrefix(contextPath, basePath), ActuatorSkipPatternProviderConfig.getPathSuffix(contextPath, basePath));
            for (ExposableWebEndpoint endpoint : endpoints) {
                String path = endpoint.getRootPath();
                String paths = path + "|" + path + "/.*";
                joiner.add(paths);
            }
            return joiner.toString();
        }

        private static String getPathPrefix(String contextPath, String actuatorBasePath) {
            String result = "";
            if (StringUtils.hasText((String)contextPath)) {
                result = result + contextPath;
            }
            if (!actuatorBasePath.equals("/")) {
                result = result + actuatorBasePath;
            }
            boolean ignoreBase = StringUtils.hasText((String)result) && !result.equals("/");
            String suffix = "/(";
            if (ignoreBase) {
                suffix = "(/|" + suffix;
            }
            return result + suffix;
        }

        private static String getPathSuffix(String contextPath, String actuatorBasePath) {
            String result = ")";
            if (StringUtils.hasText((String)contextPath) || StringUtils.hasText((String)actuatorBasePath) && !"/".equals(actuatorBasePath)) {
                result = result + ")?";
            }
            return result;
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.SAME)
        public SingleSkipPattern skipPatternForActuatorEndpointsSamePort(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(serverProperties.getServlet().getContextPath(), webEndpointProperties, endpointsSupplier);
        }

        @Bean
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @ConditionalOnProperty(name={"management.server.servlet.context-path"}, havingValue="/", matchIfMissing=true)
        public SingleSkipPattern skipPatternForActuatorEndpointsDifferentPort(ServerProperties serverProperties, WebEndpointProperties webEndpointProperties, EndpointsSupplier<ExposableWebEndpoint> endpointsSupplier) {
            return () -> ActuatorSkipPatternProviderConfig.getEndpointsPatterns(null, webEndpointProperties, endpointsSupplier);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnProperty(value={"spring.sleuth.web.ignoreAutoConfiguredSkipPatterns"}, havingValue="false", matchIfMissing=true)
    protected static class ManagementSkipPatternProviderConfig {
        protected ManagementSkipPatternProviderConfig() {
        }

        static Optional<Pattern> getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            String contextPath = managementServerProperties.getServlet().getContextPath();
            if (StringUtils.hasText((String)contextPath)) {
                return Optional.of(Pattern.compile(contextPath + ".*"));
            }
            return Optional.empty();
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SingleSkipPattern skipPatternForManagementServerProperties(ManagementServerProperties managementServerProperties) {
            return () -> ManagementSkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties);
        }
    }
}

