/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.LazyTracingClientHttpRequestInterceptor;
import org.springframework.cloud.sleuth.instrument.web.client.RestTemplateInterceptorInjector;
import org.springframework.web.client.RestTemplate;

class TraceRestTemplateBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    TraceRestTemplateBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestTemplate) {
            RestTemplate rt = (RestTemplate)bean;
            new RestTemplateInterceptorInjector(this.interceptor()).inject(rt);
        }
        return bean;
    }

    private LazyTracingClientHttpRequestInterceptor interceptor() {
        return new LazyTracingClientHttpRequestInterceptor(this.beanFactory);
    }
}

