/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Feign;
import feign.Retryer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyClient;

final class SleuthFeignBuilder {
    private SleuthFeignBuilder() {
    }

    static Feign.Builder builder(BeanFactory beanFactory) {
        return Feign.builder().retryer(Retryer.NEVER_RETRY).client(SleuthFeignBuilder.client(beanFactory));
    }

    private static Client client(BeanFactory beanFactory) {
        try {
            return new LazyClient(beanFactory);
        }
        catch (BeansException ex) {
            return new LazyClient(beanFactory, (Client)new Client.Default(null, null));
        }
    }
}

