/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.cloud.stream.binder.LastSubscriberAwareChannel;
import org.springframework.cloud.stream.binder.LastSubscriberMessageHandler;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.messaging.MessageHandler;

class BinderErrorChannel
extends PublishSubscribeChannel
implements LastSubscriberAwareChannel {
    private final AtomicInteger subscribers = new AtomicInteger();
    private volatile LastSubscriberMessageHandler finalHandler;

    BinderErrorChannel() {
    }

    public boolean subscribe(MessageHandler handler) {
        this.subscribers.incrementAndGet();
        if (handler instanceof LastSubscriberMessageHandler && this.finalHandler != null) {
            throw new IllegalStateException("Only one LastSubscriberMessageHandler is allowed");
        }
        if (this.finalHandler != null) {
            this.unsubscribe(this.finalHandler);
        }
        boolean result = super.subscribe(handler);
        if (this.finalHandler != null) {
            super.subscribe((MessageHandler)this.finalHandler);
        }
        if (handler instanceof LastSubscriberMessageHandler && this.finalHandler == null) {
            this.finalHandler = (LastSubscriberMessageHandler)handler;
        }
        return result;
    }

    public boolean unsubscribe(MessageHandler handler) {
        this.subscribers.decrementAndGet();
        return super.unsubscribe(handler);
    }

    @Override
    public int subscribers() {
        return this.subscribers.get();
    }
}

