/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.properties;

import javax.validation.constraints.Min;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.expression.Expression;

public class RabbitProducerProperties
extends RabbitCommonProperties {
    private boolean compress;
    private boolean batchingEnabled;
    private int batchSize = 100;
    private int batchBufferLimit = 10000;
    private int batchTimeout = 5000;
    private String batchingStrategyBeanName;
    private boolean transacted;
    private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;
    private String[] headerPatterns = new String[]{"*"};
    private Expression delayExpression;
    private Expression routingKeyExpression;
    private String confirmAckChannel;
    private boolean useConfirmHeader;

    @Deprecated
    public void setRequestHeaderPatterns(String[] requestHeaderPatterns) {
        this.headerPatterns = requestHeaderPatterns;
    }

    @Deprecated
    public String[] getRequestHeaderPatterns() {
        return this.headerPatterns;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setDeliveryMode(MessageDeliveryMode deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public MessageDeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public String[] getHeaderPatterns() {
        return this.headerPatterns;
    }

    public void setHeaderPatterns(String[] replyHeaderPatterns) {
        this.headerPatterns = replyHeaderPatterns;
    }

    public boolean isBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    @Min(value=1L, message="Batch Size should be greater than zero.")
    public @Min(value=1L, message="Batch Size should be greater than zero.") int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Min(value=1L, message="Batch Buffer Limit should be greater than zero.")
    public @Min(value=1L, message="Batch Buffer Limit should be greater than zero.") int getBatchBufferLimit() {
        return this.batchBufferLimit;
    }

    public void setBatchBufferLimit(int batchBufferLimit) {
        this.batchBufferLimit = batchBufferLimit;
    }

    @Min(value=1L, message="Batch Timeout should be greater than zero.")
    public @Min(value=1L, message="Batch Timeout should be greater than zero.") int getBatchTimeout() {
        return this.batchTimeout;
    }

    public void setBatchTimeout(int batchTimeout) {
        this.batchTimeout = batchTimeout;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public Expression getDelayExpression() {
        return this.delayExpression;
    }

    public void setDelayExpression(Expression delayExpression) {
        this.delayExpression = delayExpression;
    }

    public Expression getRoutingKeyExpression() {
        return this.routingKeyExpression;
    }

    public void setRoutingKeyExpression(Expression routingKeyExpression) {
        this.routingKeyExpression = routingKeyExpression;
    }

    public String getConfirmAckChannel() {
        return this.confirmAckChannel;
    }

    public void setConfirmAckChannel(String confirmAckChannel) {
        this.confirmAckChannel = confirmAckChannel;
    }

    public String getBatchingStrategyBeanName() {
        return this.batchingStrategyBeanName;
    }

    public void setBatchingStrategyBeanName(String batchingStrategyBeanName) {
        this.batchingStrategyBeanName = batchingStrategyBeanName;
    }

    public boolean isUseConfirmHeader() {
        return this.useConfirmHeader;
    }

    public void setUseConfirmHeader(boolean useConfirmHeader) {
        this.useConfirmHeader = useConfirmHeader;
    }
}

