/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.configuration;

import java.util.HashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResourceLoader;
import org.springframework.cloud.deployer.resource.support.DelegatingResourceLoader;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ResourceLoadingAutoConfiguration {

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.deployer.resource.maven.MavenResourceLoader"})
    public static class LocalResourceLoadingAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public DelegatingResourceLoader delegatingResourceLoader() {
            return new DelegatingResourceLoader();
        }
    }

    @Configuration
    @ConditionalOnClass(value={MavenResourceLoader.class})
    public static class MavenResourceLoadingAutoConfiguration {
        @Bean
        public MavenResourceLoader mavenResourceLoader(MavenProperties mavenProperties) {
            return new MavenResourceLoader(mavenProperties);
        }

        @Bean
        @ConditionalOnMissingBean
        public DelegatingResourceLoader delegatingResourceLoader(MavenResourceLoader mavenResourceLoader) {
            HashMap<String, MavenResourceLoader> loaders = new HashMap<String, MavenResourceLoader>(1);
            loaders.put("maven", mavenResourceLoader);
            return new DelegatingResourceLoader(loaders);
        }

        @Bean
        public MavenProperties mavenProperties() {
            return new MavenConfigurationProperties();
        }

        @ConfigurationProperties(prefix="maven")
        public static class MavenConfigurationProperties
        extends MavenProperties {
        }
    }
}

