/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.database.support;

import org.springframework.cloud.task.repository.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.cloud.task.repository.database.support.SqlPagingQueryUtils;
import org.springframework.data.domain.Pageable;

public class OraclePagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String getPageQuery(Pageable pageable) {
        int offset = pageable.getOffset() + 1;
        return this.generateRowNumSqlQueryWithNesting(this.getSelectClause(), false, "TMP_ROW_NUM >= " + offset + " AND TMP_ROW_NUM < " + (offset + pageable.getPageSize()));
    }

    private String generateRowNumSqlQueryWithNesting(String selectClause, boolean remainingPageQuery, String rowNumClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ").append(selectClause).append(" FROM (SELECT ").append(selectClause).append(", ").append("ROWNUM as TMP_ROW_NUM");
        sql.append(" FROM (SELECT ").append(selectClause).append(" FROM ").append(this.getFromClause());
        SqlPagingQueryUtils.buildWhereClause(this, remainingPageQuery, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this));
        sql.append(")) WHERE ").append(rowNumClause);
        return sql.toString();
    }
}

