/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceKeyCommands;
import org.springframework.data.redis.connection.lettuce.LettuceScanCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class LettuceClusterKeyCommands
extends LettuceKeyCommands {
    private final LettuceClusterConnection connection;

    LettuceClusterKeyCommands(LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public byte[] randomKey() {
        Iterable nodes = this.connection.clusterGetNodes();
        HashSet<RedisClusterNode> inspectedNodes = new HashSet<RedisClusterNode>(nodes.size());
        do {
            RedisClusterNode node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            while (inspectedNodes.contains(node)) {
                node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            }
            inspectedNodes.add(node);
            byte[] key = this.randomKey(node);
            if (key == null || key.length <= 0) continue;
            return key;
        } while (nodes.size() != inspectedNodes.size());
        return null;
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        List keysPerNode = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(connection -> connection.keys((Object)pattern)).resultsAsList();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (List keySet : keysPerNode) {
            keys.addAll(keySet);
        }
        return keys;
    }

    @Override
    public void rename(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            super.rename(sourceKey, targetKey);
            return;
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
        }
    }

    @Override
    public Boolean renameNX(byte[] sourceKey, byte[] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            return super.renameNX(sourceKey, targetKey);
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0 && !this.exists(targetKey).booleanValue()) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean move(byte[] key, int dbIndex) {
        throw new UnsupportedOperationException("MOVE not supported in CLUSTER mode!");
    }

    @Nullable
    public byte[] randomKey(RedisClusterNode node) {
        return (byte[])this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> (byte[])client.randomkey(), node).getValue();
    }

    @Nullable
    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        return LettuceConverters.toBytesSet((List)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.keys((Object)pattern), node).getValue());
    }

    Cursor<byte[]> scan(RedisClusterNode node, ScanOptions options) {
        Assert.notNull((Object)node, (String)"RedisClusterNode must not be null!");
        Assert.notNull((Object)options, (String)"Options must not be null!");
        return (Cursor)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> new LettuceScanCursor<byte[]>(options){

            @Override
            protected LettuceScanCursor.LettuceScanIteration<byte[]> doScan(ScanCursor cursor, ScanOptions options) {
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                KeyScanCursor keyScanCursor = client.scan(cursor, scanArgs);
                return new LettuceScanCursor.LettuceScanIteration<byte[]>((ScanCursor)keyScanCursor, keyScanCursor.getKeys());
            }
        }.open(), node).getValue();
    }

    @Override
    public Long sort(byte[] key, SortParameters params, byte[] storeKey) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(key, storeKey)) {
            return super.sort(key, params, storeKey);
        }
        List<byte[]> sorted = this.sort(key, params);
        if (!CollectionUtils.isEmpty(sorted)) {
            byte[][] arr = new byte[sorted.size()][];
            switch (this.type(key)) {
                case SET: {
                    this.connection.setCommands().sAdd(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
                case LIST: {
                    this.connection.listCommands().lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
                    return 1L;
                }
            }
            throw new IllegalArgumentException("sort and store is only supported for SET and LIST");
        }
        return 0L;
    }
}

