/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class PersistentPropertyResourceMapping
implements PropertyAwareResourceMapping {
    private final PersistentProperty<?> property;
    private final ResourceMappings mappings;
    private final RestResource annotation;
    private final Description description;

    public PersistentPropertyResourceMapping(PersistentProperty<?> property, ResourceMappings mappings) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        this.property = property;
        this.mappings = mappings;
        this.annotation = property.isAssociation() ? (RestResource)property.findAnnotation(RestResource.class) : null;
        this.description = (Description)property.findAnnotation(Description.class);
    }

    @Override
    public Path getPath() {
        return this.annotation != null && StringUtils.hasText((String)this.annotation.path()) ? new Path(this.annotation.path()) : new Path(this.property.getName());
    }

    @Override
    public String getRel() {
        return this.annotation != null && StringUtils.hasText((String)this.annotation.rel()) ? this.annotation.rel() : this.property.getName();
    }

    @Override
    public boolean isExported() {
        if (!this.property.isAssociation()) {
            return false;
        }
        ResourceMetadata typeMapping = this.mappings.getMetadataFor(this.property.getActualType());
        return !typeMapping.isExported() ? false : (this.annotation == null ? true : this.annotation.exported());
    }

    @Override
    public boolean isPagingResource() {
        return false;
    }

    @Override
    public ResourceDescription getDescription() {
        ResourceMetadata ownerTypeMapping = this.mappings.getMetadataFor(this.property.getOwner().getType());
        ResourceDescription fallback = TypedResourceDescription.defaultFor(ownerTypeMapping.getItemResourceRel(), this.property);
        if (this.description != null) {
            return new AnnotationBasedResourceDescription(this.description, fallback);
        }
        if (this.annotation != null) {
            return new AnnotationBasedResourceDescription(this.annotation.description(), fallback);
        }
        return fallback;
    }

    @Override
    public PersistentProperty<?> getProperty() {
        return this.property;
    }
}

