/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.data.rest.core.mapping.ResolvableResourceDescriptionSupport;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleResourceDescription
extends ResolvableResourceDescriptionSupport {
    public static final String DEFAULT_KEY_PREFIX = "rest.description";
    protected static final MediaType DEFAULT_MEDIA_TYPE = MediaType.TEXT_PLAIN;
    private final String message;
    private final MediaType mediaType;

    protected SimpleResourceDescription(String message, MediaType mediaType) {
        Assert.hasText((String)message, (String)"Message must not be null or empty!");
        Assert.notNull((Object)mediaType, (String)"MediaType must not be null!");
        this.message = message;
        this.mediaType = mediaType;
    }

    public static ResourceDescription defaultFor(String rel) {
        return new SimpleResourceDescription(String.format("%s.%s", DEFAULT_KEY_PREFIX, rel), DEFAULT_MEDIA_TYPE);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public MediaType getType() {
        return this.mediaType;
    }

    @Override
    public boolean isDefault() {
        return StringUtils.hasText((String)this.message) && this.message.startsWith(DEFAULT_KEY_PREFIX);
    }

    public String[] getCodes() {
        return new String[]{this.message};
    }
}

