/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.Lifecycle;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.support.channel.HeaderChannelRegistry;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class DefaultHeaderChannelRegistry
extends IntegrationObjectSupport
implements HeaderChannelRegistry,
Lifecycle,
Runnable {
    private static final int DEFAULT_REAPER_DELAY = 60000;
    protected static final AtomicLong id = new AtomicLong();
    protected final Map<String, MessageChannelWrapper> channels = new ConcurrentHashMap<String, MessageChannelWrapper>();
    protected final String uuid = UUID.randomUUID().toString() + ":";
    private boolean removeOnGet;
    private long reaperDelay;
    private volatile ScheduledFuture<?> reaperScheduledFuture;
    private volatile boolean running;
    private volatile boolean explicitlyStopped;

    public DefaultHeaderChannelRegistry() {
        this(60000L);
    }

    public DefaultHeaderChannelRegistry(long reaperDelay) {
        this.setReaperDelay(reaperDelay);
    }

    public final void setReaperDelay(long reaperDelay) {
        Assert.isTrue((reaperDelay > 0L ? 1 : 0) != 0, (String)"'reaperDelay' must be > 0");
        this.reaperDelay = reaperDelay;
    }

    public final long getReaperDelay() {
        return this.reaperDelay;
    }

    public void setRemoveOnGet(boolean removeOnGet) {
        this.removeOnGet = removeOnGet;
    }

    @Override
    public void setTaskScheduler(TaskScheduler taskScheduler) {
        super.setTaskScheduler(taskScheduler);
    }

    @Override
    public final int size() {
        return this.channels.size();
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        Assert.notNull((Object)this.getTaskScheduler(), (String)"a task scheduler is required");
    }

    public synchronized void start() {
        if (!this.running) {
            Assert.notNull((Object)this.getTaskScheduler(), (String)"a task scheduler is required");
            this.reaperScheduledFuture = this.getTaskScheduler().schedule((Runnable)this, new Date(System.currentTimeMillis() + this.reaperDelay));
            this.running = true;
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.reaperScheduledFuture != null) {
            this.reaperScheduledFuture.cancel(true);
            this.reaperScheduledFuture = null;
        }
        this.explicitlyStopped = true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Object channelToChannelName(@Nullable Object channel) {
        return this.channelToChannelName(channel, this.reaperDelay);
    }

    @Override
    public Object channelToChannelName(@Nullable Object channel, long timeToLive) {
        if (!this.running && !this.explicitlyStopped && this.getTaskScheduler() != null) {
            this.start();
        }
        if (channel != null && channel instanceof MessageChannel) {
            String name = this.uuid + id.incrementAndGet();
            this.channels.put(name, new MessageChannelWrapper((MessageChannel)channel, System.currentTimeMillis() + timeToLive));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Registered " + channel + " as " + name));
            }
            return name;
        }
        return channel;
    }

    @Override
    public MessageChannel channelNameToChannel(@Nullable String name) {
        if (name != null) {
            MessageChannelWrapper messageChannelWrapper = this.removeOnGet ? this.channels.remove(name) : this.channels.get(name);
            if (this.logger.isDebugEnabled() && messageChannelWrapper != null) {
                this.logger.debug((Object)("Retrieved " + messageChannelWrapper.getChannel() + " with " + name));
            }
            return messageChannelWrapper == null ? null : messageChannelWrapper.getChannel();
        }
        return null;
    }

    @Override
    public synchronized void runReaper() {
        if (this.reaperScheduledFuture != null) {
            this.reaperScheduledFuture.cancel(true);
            this.reaperScheduledFuture = null;
        }
        this.run();
    }

    @Override
    public synchronized void run() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reaper started; channels size=" + this.channels.size()));
        }
        Iterator<Map.Entry<String, MessageChannelWrapper>> iterator = this.channels.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (iterator.hasNext()) {
            Map.Entry<String, MessageChannelWrapper> entry = iterator.next();
            if (entry.getValue().getExpireAt() >= now) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Expiring " + entry.getKey() + " (" + entry.getValue().getChannel() + ")"));
            }
            iterator.remove();
        }
        this.reaperScheduledFuture = this.getTaskScheduler().schedule((Runnable)this, new Date(System.currentTimeMillis() + this.reaperDelay));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Reaper completed; channels size=" + this.channels.size()));
        }
    }

    private static final class MessageChannelWrapper {
        private final MessageChannel channel;
        private final long expireAt;

        MessageChannelWrapper(MessageChannel channel, long expireAt) {
            this.channel = channel;
            this.expireAt = expireAt;
        }

        public long getExpireAt() {
            return this.expireAt;
        }

        public MessageChannel getChannel() {
            return this.channel;
        }
    }
}

