/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.expression;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.Lifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.MethodFilter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.ReflectionUtils;

public class ControlBusMethodFilter
implements MethodFilter {
    public List<Method> filter(List<Method> methods) {
        ArrayList<Method> supportedMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!this.accept(method)) continue;
            supportedMethods.add(method);
        }
        return supportedMethods;
    }

    private boolean accept(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (Lifecycle.class.isAssignableFrom(declaringClass) && ReflectionUtils.findMethod(Lifecycle.class, (String)method.getName(), (Class[])method.getParameterTypes()) != null) {
            return true;
        }
        if (CustomizableThreadCreator.class.isAssignableFrom(declaringClass) && (method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("shutdown"))) {
            return true;
        }
        return this.hasAnnotation(method, ManagedAttribute.class) || this.hasAnnotation(method, ManagedOperation.class);
    }

    private boolean hasAnnotation(Method method, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.findAnnotation((Method)method, annotationType) != null;
    }
}

