/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.time.Duration;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class DynamicPeriodicTrigger
implements Trigger {
    private volatile Duration initialDuration = Duration.ofMillis(0L);
    private volatile Duration duration;
    private volatile TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private volatile boolean fixedRate = false;

    public DynamicPeriodicTrigger(long period) {
        this(Duration.ofMillis(period));
    }

    @Deprecated
    public DynamicPeriodicTrigger(long period, TimeUnit timeUnit) {
        Assert.isTrue((period >= 0L ? 1 : 0) != 0, (String)"period must not be negative");
        Assert.notNull((Object)((Object)timeUnit), (String)"timeUnit must not be null");
        this.timeUnit = timeUnit;
        this.duration = Duration.ofMillis(this.timeUnit.toMillis(period));
    }

    public DynamicPeriodicTrigger(Duration duration) {
        Assert.notNull((Object)duration, (String)"duration must not be null");
        Assert.isTrue((!duration.isNegative() ? 1 : 0) != 0, (String)"duration must not be negative");
        this.duration = duration;
    }

    @Deprecated
    public void setInitialDelay(long initialDelay) {
        Assert.isTrue((initialDelay >= 0L ? 1 : 0) != 0, (String)"initialDelay must not be negative");
        this.initialDuration = Duration.ofMillis(this.timeUnit.toMillis(initialDelay));
    }

    public void setInitialDuration(Duration initialDuration) {
        Assert.notNull((Object)initialDuration, (String)"initialDuration must not be null");
        Assert.isTrue((!initialDuration.isNegative() ? 1 : 0) != 0, (String)"initialDuration must not be negative");
        this.initialDuration = initialDuration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getInitialDuration() {
        return this.initialDuration;
    }

    public void setFixedRate(boolean fixedRate) {
        this.fixedRate = fixedRate;
    }

    @Deprecated
    public long getPeriod() {
        return this.duration.toMillis();
    }

    @Deprecated
    public void setPeriod(long period) {
        Assert.isTrue((period >= 0L ? 1 : 0) != 0, (String)"period must not be negative");
        this.duration = Duration.ofMillis(this.timeUnit.toMillis(period));
    }

    @Deprecated
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Deprecated
    public void setTimeUnit(TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"timeUnit must not be null");
        this.timeUnit = timeUnit;
    }

    @Deprecated
    public long getInitialDelay() {
        return this.initialDuration.toMillis();
    }

    public boolean isFixedRate() {
        return this.fixedRate;
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        if (triggerContext.lastScheduledExecutionTime() == null) {
            return new Date(System.currentTimeMillis() + this.initialDuration.toMillis());
        }
        if (this.fixedRate) {
            return new Date(triggerContext.lastScheduledExecutionTime().getTime() + this.duration.toMillis());
        }
        return new Date(triggerContext.lastCompletionTime().getTime() + this.duration.toMillis());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
        result = 31 * result + (this.fixedRate ? 1231 : 1237);
        result = 31 * result + (this.initialDuration == null ? 0 : this.initialDuration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynamicPeriodicTrigger other = (DynamicPeriodicTrigger)obj;
        if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
            return false;
        }
        if (this.fixedRate != other.fixedRate) {
            return false;
        }
        return !(this.initialDuration == null ? other.initialDuration != null : !this.initialDuration.equals(other.initialDuration));
    }
}

