/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.task.TaskExecutor;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.integration.annotation.IdempotentReceiver;
import org.springframework.integration.annotation.Poller;
import org.springframework.integration.annotation.Reactive;
import org.springframework.integration.annotation.Role;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.PeriodicTriggerFactoryBean;
import org.springframework.integration.config.RouterFactoryBean;
import org.springframework.integration.config.annotation.MethodAnnotationPostProcessor;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.AbstractPollingEndpoint;
import org.springframework.integration.endpoint.EventDrivenConsumer;
import org.springframework.integration.endpoint.PollingConsumer;
import org.springframework.integration.endpoint.ReactiveStreamsConsumer;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.handler.LambdaMessageProcessor;
import org.springframework.integration.handler.ReactiveMessageHandlerAdapter;
import org.springframework.integration.handler.ReplyProducingMessageHandlerWrapper;
import org.springframework.integration.handler.advice.HandleMessageAdvice;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.integration.support.channel.ChannelResolverUtils;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMethodAnnotationPostProcessor<T extends Annotation>
implements MethodAnnotationPostProcessor<T>,
BeanFactoryAware {
    private static final String UNCHECKED = "unchecked";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final String ADVICE_CHAIN_ATTRIBUTE = "adviceChain";
    protected static final String SEND_TIMEOUT_ATTRIBUTE = "sendTimeout";
    protected final List<String> messageHandlerAttributes = new ArrayList<String>();
    protected final Class<T> annotationType;
    private ConfigurableListableBeanFactory beanFactory;
    private BeanDefinitionRegistry definitionRegistry;
    private ConversionService conversionService;
    private volatile DestinationResolver<MessageChannel> channelResolver;

    public AbstractMethodAnnotationPostProcessor() {
        this.messageHandlerAttributes.add(SEND_TIMEOUT_ATTRIBUTE);
        this.annotationType = GenericTypeResolver.resolveTypeArgument(this.getClass(), MethodAnnotationPostProcessor.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.definitionRegistry = (BeanDefinitionRegistry)beanFactory;
        this.conversionService = this.beanFactory.getConversionService() != null ? this.beanFactory.getConversionService() : DefaultConversionService.getSharedInstance();
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected BeanDefinitionRegistry getDefinitionRegistry() {
        return this.definitionRegistry;
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    protected DestinationResolver<MessageChannel> getChannelResolver() {
        if (this.channelResolver == null) {
            this.channelResolver = ChannelResolverUtils.getChannelResolver((BeanFactory)this.beanFactory);
        }
        return this.channelResolver;
    }

    @Override
    public void processBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, List<Annotation> annotations) {
        ResolvableType handlerBeanType = this.getHandlerBeanClass(beanDefinition);
        String handlerBeanName = beanName;
        BeanDefinition handlerBeanDefinition = this.resolveHandlerBeanDefinition(beanName, beanDefinition, handlerBeanType, annotations);
        MergedAnnotations mergedAnnotations = beanDefinition.getFactoryMethodMetadata().getAnnotations();
        if (handlerBeanDefinition != null) {
            if (!handlerBeanDefinition.equals(beanDefinition)) {
                String beanClassName = handlerBeanDefinition.getBeanClassName();
                Assert.notNull((Object)beanClassName, (String)("No bean class present for " + handlerBeanDefinition));
                Class handlerBeanClass = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.beanFactory.getBeanClassLoader());
                if (AbstractMethodAnnotationPostProcessor.isClassIn(handlerBeanClass, Orderable.class, AbstractSimpleMessageHandlerFactoryBean.class)) {
                    mergedAnnotations.get(Order.class).getValue("value", String.class).ifPresent(order -> handlerBeanDefinition.getPropertyValues().add("order", order));
                }
                if (AbstractMethodAnnotationPostProcessor.isClassIn(handlerBeanClass, AbstractMessageProducingHandler.class, AbstractMessageRouter.class, AbstractSimpleMessageHandlerFactoryBean.class)) {
                    new BeanDefinitionPropertiesMapper(handlerBeanDefinition, annotations).setPropertyValue(SEND_TIMEOUT_ATTRIBUTE).setPropertyValue("outputChannel", "outputChannelName").setPropertyValue("defaultOutputChannel", "defaultOutputChannelName");
                }
                if (AbstractMethodAnnotationPostProcessor.isClassIn(handlerBeanClass, AbstractMessageProducingHandler.class, AbstractSimpleMessageHandlerFactoryBean.class) && !RouterFactoryBean.class.isAssignableFrom(handlerBeanClass)) {
                    AbstractMethodAnnotationPostProcessor.applyAdviceChainIfAny(handlerBeanDefinition, annotations);
                }
                handlerBeanName = this.generateHandlerBeanName(beanName, mergedAnnotations);
                this.definitionRegistry.registerBeanDefinition(handlerBeanName, handlerBeanDefinition);
            }
        } else {
            throw new BeanDefinitionValidationException("The messaging annotation processor for '" + this.annotationType + "' cannot create a target handler bean. The bean definition with the problem is: " + beanName);
        }
        BeanDefinition endpointBeanDefinition = this.createEndpointBeanDefinition((ComponentDefinition)new BeanComponentDefinition(handlerBeanDefinition, handlerBeanName), (ComponentDefinition)new BeanComponentDefinition((BeanDefinition)beanDefinition, beanName), annotations);
        new BeanDefinitionPropertiesMapper(endpointBeanDefinition, annotations).setPropertyValue("autoStartup").setPropertyValue("phase");
        Poller poller = MessagingAnnotationUtils.resolveAttribute(annotations, "poller", Poller.class);
        Reactive reactive = MessagingAnnotationUtils.resolveAttribute(annotations, "reactive", Reactive.class);
        Assert.state((reactive == null || poller == null ? 1 : 0) != 0, () -> "The 'poller' and 'reactive' attributes are mutually exclusive.The bean definition with the problem is: " + beanName);
        if (poller != null) {
            AbstractMethodAnnotationPostProcessor.applyPollerForEndpoint(endpointBeanDefinition, poller);
        } else if (reactive != null) {
            String reactiveCustomizerBean = reactive.value();
            Object reactiveCustomizer = StringUtils.hasText((String)reactiveCustomizerBean) ? new RuntimeBeanReference(reactiveCustomizerBean) : BeanDefinitionBuilder.genericBeanDefinition(Function.class).setFactoryMethod("identity").getBeanDefinition();
            endpointBeanDefinition.getPropertyValues().add("reactiveCustomizer", reactiveCustomizer);
        }
        mergedAnnotations.get(Role.class).getValue("value", String.class).ifPresent(role -> endpointBeanDefinition.getPropertyValues().add("role", role));
        String endpointBeanName = this.generateHandlerBeanName(beanName, mergedAnnotations).replaceFirst("\\.(handler|source)$", "");
        this.beanFactory.registerDependentBean(beanName, endpointBeanName);
        this.definitionRegistry.registerBeanDefinition(endpointBeanName, endpointBeanDefinition);
    }

    private static boolean isClassIn(Class<?> classToVerify, Class<?> ... classesToMatch) {
        for (Class<?> toMatch : classesToMatch) {
            if (!toMatch.isAssignableFrom(classToVerify)) continue;
            return true;
        }
        return false;
    }

    protected BeanDefinition createEndpointBeanDefinition(ComponentDefinition handlerBeanDefinition, ComponentDefinition beanDefinition, List<Annotation> annotations) {
        BeanDefinitionBuilder endpointDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConsumerEndpointFactoryBean.class).addPropertyReference("handler", handlerBeanDefinition.getName());
        String inputChannelAttribute = this.getInputChannelAttribute();
        String inputChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, inputChannelAttribute, String.class);
        Assert.hasText((String)inputChannelName, () -> "The '" + inputChannelAttribute + "' attribute is required on '" + this.annotationType + "' on @Bean method");
        if (!this.definitionRegistry.containsBeanDefinition(inputChannelName)) {
            this.definitionRegistry.registerBeanDefinition(inputChannelName, (BeanDefinition)new RootBeanDefinition(DirectChannel.class));
        }
        AbstractBeanDefinition endpointBeanDefinition = endpointDefinitionBuilder.addPropertyReference("inputChannel", inputChannelName).getBeanDefinition();
        AbstractMethodAnnotationPostProcessor.applyAdviceChainIfAny((BeanDefinition)endpointBeanDefinition, annotations);
        return endpointBeanDefinition;
    }

    private static void applyAdviceChainIfAny(BeanDefinition beanDefinition, List<Annotation> annotations) {
        Object[] adviceChainNames = MessagingAnnotationUtils.resolveAttribute(annotations, ADVICE_CHAIN_ATTRIBUTE, String[].class);
        if (!ObjectUtils.isEmpty((Object[])adviceChainNames)) {
            ManagedList adviceChain = Arrays.stream(adviceChainNames).map(RuntimeBeanReference::new).collect(Collectors.toCollection(ManagedList::new));
            beanDefinition.getPropertyValues().addPropertyValue(ADVICE_CHAIN_ATTRIBUTE, (Object)adviceChain);
        }
    }

    private static void applyPollerForEndpoint(BeanDefinition endpointBeanDefinition, Poller poller) {
        RuntimeBeanReference pollerMetadataBeanDefinition;
        String ref = poller.value();
        if (StringUtils.hasText((String)ref)) {
            pollerMetadataBeanDefinition = new RuntimeBeanReference(ref);
        } else {
            BeanDefinitionBuilder pollerBeanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(PollerMetadata.class);
            new BeanDefinitionPropertiesMapper((BeanDefinition)pollerBeanDefinitionBuilder.getRawBeanDefinition(), List.of(poller)).setPropertyReference("trigger").setPropertyReference("taskExecutor").setPropertyValue("receiveTimeout").setPropertyValue("maxMessagesPerPoll");
            String errorChannel = poller.errorChannel();
            if (StringUtils.hasText((String)errorChannel)) {
                BeanDefinitionBuilder errorHandler = BeanDefinitionBuilder.genericBeanDefinition(MessagePublishingErrorHandler.class).addPropertyReference("defaultErrorChannel", errorChannel);
                pollerBeanDefinitionBuilder.addPropertyValue("errorHandler", (Object)errorHandler.getBeanDefinition());
            }
            String fixedDelay = poller.fixedDelay();
            String fixedRate = poller.fixedRate();
            String cron = poller.cron();
            BeanDefinition triggerBeanDefinition = null;
            if (StringUtils.hasText((String)cron)) {
                triggerBeanDefinition = AbstractMethodAnnotationPostProcessor.triggerBeanDefinition(CronTrigger.class, cron);
            } else if (StringUtils.hasText((String)fixedDelay)) {
                triggerBeanDefinition = AbstractMethodAnnotationPostProcessor.triggerBeanDefinition(PeriodicTrigger.class, fixedDelay);
            } else if (StringUtils.hasText((String)fixedRate)) {
                triggerBeanDefinition = AbstractMethodAnnotationPostProcessor.triggerBeanDefinition(PeriodicTrigger.class, fixedRate);
                triggerBeanDefinition.getPropertyValues().addPropertyValue("fixedRate", (Object)true);
            }
            if (triggerBeanDefinition != null) {
                pollerBeanDefinitionBuilder.addPropertyValue("trigger", (Object)triggerBeanDefinition);
            }
            pollerMetadataBeanDefinition = pollerBeanDefinitionBuilder.getBeanDefinition();
        }
        endpointBeanDefinition.getPropertyValues().addPropertyValue("pollerMetadata", (Object)pollerMetadataBeanDefinition);
    }

    private static BeanDefinition triggerBeanDefinition(Class<? extends Trigger> triggerClass, String triggerValue) {
        return BeanDefinitionBuilder.genericBeanDefinition(triggerClass).addConstructorArgValue((Object)triggerValue).getBeanDefinition();
    }

    private ResolvableType getHandlerBeanClass(AnnotatedBeanDefinition beanDefinition) {
        MethodMetadata factoryMethodMetadata = beanDefinition.getFactoryMethodMetadata();
        if (factoryMethodMetadata instanceof StandardMethodMetadata) {
            StandardMethodMetadata standardMethodMetadata = (StandardMethodMetadata)factoryMethodMetadata;
            return ResolvableType.forMethodReturnType((Method)standardMethodMetadata.getIntrospectedMethod());
        }
        Assert.notNull((Object)factoryMethodMetadata, (String)("No factoryMethodMetadata present for " + beanDefinition));
        String typeName = factoryMethodMetadata.getReturnTypeName();
        Class beanClass = ClassUtils.resolveClassName((String)typeName, (ClassLoader)this.beanFactory.getBeanClassLoader());
        return ResolvableType.forClass((Class)beanClass);
    }

    @Nullable
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotations) {
        Class classToCheck = handlerBeanType.toClass();
        if (AbstractSimpleMessageHandlerFactoryBean.class.isAssignableFrom(classToCheck)) {
            return beanDefinition;
        }
        if (FactoryBean.class.isAssignableFrom(classToCheck)) {
            classToCheck = this.beanFactory.getType(beanName);
        }
        if (AbstractMethodAnnotationPostProcessor.isClassIn(classToCheck, AbstractMessageProducingHandler.class, AbstractMessageRouter.class)) {
            this.checkMessageHandlerAttributes(beanName, annotations);
            return beanDefinition;
        }
        return null;
    }

    @Override
    public Object postProcess(Object bean, String beanName, Method method, List<Annotation> annotations) {
        AbstractEndpoint endpoint;
        MessageHandler handler = this.createHandler(bean, method, annotations);
        if (!(handler instanceof ReactiveMessageHandlerAdapter)) {
            AbstractMethodAnnotationPostProcessor.orderable(method, handler);
            this.producerOrRouter(annotations, handler);
            handler = this.registerHandlerBean(beanName, method, handler);
            handler = this.annotated(method, handler);
            handler = this.adviceChain(beanName, annotations, handler);
        }
        if ((endpoint = this.createEndpoint(handler, method, annotations)) != null) {
            return endpoint;
        }
        return handler;
    }

    private MessageHandler registerHandlerBean(String beanName, Method method, MessageHandler handler) {
        Object handlerBeanName = this.generateHandlerBeanName(beanName, method);
        if (handler instanceof ReplyProducingMessageHandlerWrapper && StringUtils.hasText((String)MessagingAnnotationUtils.endpointIdValue(method))) {
            handlerBeanName = (String)handlerBeanName + ".wrapper";
        }
        if (handler instanceof IntegrationObjectSupport) {
            IntegrationObjectSupport integrationObjectSupport = (IntegrationObjectSupport)handler;
            integrationObjectSupport.setComponentName(((String)handlerBeanName).substring(0, ((String)handlerBeanName).indexOf(".handler")));
        }
        this.definitionRegistry.registerBeanDefinition((String)handlerBeanName, (BeanDefinition)new RootBeanDefinition(MessageHandler.class, () -> handler));
        return (MessageHandler)this.beanFactory.getBean((String)handlerBeanName, MessageHandler.class);
    }

    private void producerOrRouter(List<Annotation> annotations, MessageHandler handler) {
        String resolvedValue;
        String sendTimeout;
        if ((handler instanceof AbstractMessageProducingHandler || handler instanceof AbstractMessageRouter) && (sendTimeout = MessagingAnnotationUtils.resolveAttribute(annotations, SEND_TIMEOUT_ATTRIBUTE, String.class)) != null && (resolvedValue = this.beanFactory.resolveEmbeddedValue(sendTimeout)) != null) {
            long value = Long.parseLong(resolvedValue);
            if (handler instanceof AbstractMessageProducingHandler) {
                AbstractMessageProducingHandler abstractMessageProducingHandler = (AbstractMessageProducingHandler)handler;
                abstractMessageProducingHandler.setSendTimeout(value);
            } else {
                ((AbstractMessageRouter)handler).setSendTimeout(value);
            }
        }
    }

    private MessageHandler annotated(Method method, MessageHandler handlerArg) {
        MessageHandler handler = handlerArg;
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)IdempotentReceiver.class.getName()) && !AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, (String)Bean.class.getName())) {
            String[] interceptors;
            for (String interceptor : interceptors = ((IdempotentReceiver)AnnotationUtils.getAnnotation((Method)method, IdempotentReceiver.class)).value()) {
                DefaultBeanFactoryPointcutAdvisor advisor = new DefaultBeanFactoryPointcutAdvisor();
                advisor.setAdviceBeanName(interceptor);
                NameMatchMethodPointcut pointcut = new NameMatchMethodPointcut();
                pointcut.setMappedName("handleMessage");
                advisor.setPointcut((Pointcut)pointcut);
                advisor.setBeanFactory((BeanFactory)this.beanFactory);
                if (handler instanceof Advised) {
                    Advised advised = (Advised)handler;
                    advised.addAdvisor((Advisor)advisor);
                    continue;
                }
                ProxyFactory proxyFactory = new ProxyFactory((Object)handler);
                proxyFactory.addAdvisor((Advisor)advisor);
                handler = (MessageHandler)proxyFactory.getProxy(this.beanFactory.getBeanClassLoader());
            }
        }
        return handler;
    }

    private MessageHandler adviceChain(String beanName, List<Annotation> annotations, MessageHandler handlerArg) {
        MessageHandler handler = handlerArg;
        List<Advice> adviceChain = this.extractAdviceChain(beanName, annotations);
        if (!CollectionUtils.isEmpty(adviceChain) && handler instanceof AbstractReplyProducingMessageHandler) {
            AbstractReplyProducingMessageHandler abstractReplyProducingMessageHandler = (AbstractReplyProducingMessageHandler)handler;
            abstractReplyProducingMessageHandler.setAdviceChain(adviceChain);
        }
        if (!CollectionUtils.isEmpty(adviceChain)) {
            for (Advice advice : adviceChain) {
                if (!(advice instanceof HandleMessageAdvice)) continue;
                NameMatchMethodPointcutAdvisor handlerAdvice = new NameMatchMethodPointcutAdvisor(advice);
                handlerAdvice.addMethodName("handleMessage");
                if (handler instanceof Advised) {
                    Advised advised = (Advised)handler;
                    advised.addAdvisor((Advisor)handlerAdvice);
                    continue;
                }
                ProxyFactory proxyFactory = new ProxyFactory((Object)handler);
                proxyFactory.addAdvisor((Advisor)handlerAdvice);
                handler = (MessageHandler)proxyFactory.getProxy(this.beanFactory.getBeanClassLoader());
            }
        }
        return handler;
    }

    protected List<Advice> extractAdviceChain(String beanName, List<Annotation> annotations) {
        ArrayList<Advice> adviceChain = null;
        String[] adviceChainNames = MessagingAnnotationUtils.resolveAttribute(annotations, ADVICE_CHAIN_ATTRIBUTE, String[].class);
        if (adviceChainNames != null && adviceChainNames.length > 0) {
            adviceChain = new ArrayList<Advice>();
            for (String adviceChainName : adviceChainNames) {
                Object adviceChainBean = this.beanFactory.getBean(adviceChainName);
                if (adviceChainBean instanceof Advice) {
                    Advice advice = (Advice)adviceChainBean;
                    adviceChain.add(advice);
                    continue;
                }
                if (adviceChainBean instanceof Advice[]) {
                    Advice[] advices = (Advice[])adviceChainBean;
                    Collections.addAll(adviceChain, advices);
                    continue;
                }
                if (adviceChainBean instanceof Collection) {
                    Collection adviceChainEntries = (Collection)adviceChainBean;
                    adviceChain.addAll(adviceChainEntries);
                    continue;
                }
                throw new IllegalArgumentException("Invalid advice chain type:" + adviceChainName.getClass().getName() + " for bean '" + beanName + "'");
            }
        }
        return adviceChain;
    }

    protected AbstractEndpoint createEndpoint(MessageHandler handler, Method method, List<Annotation> annotations) {
        AbstractEndpoint endpoint = null;
        String inputChannelName = MessagingAnnotationUtils.resolveAttribute(annotations, this.getInputChannelAttribute(), String.class);
        if (StringUtils.hasText((String)inputChannelName)) {
            MessageChannel inputChannel;
            try {
                inputChannel = (MessageChannel)this.getChannelResolver().resolveDestination(inputChannelName);
            }
            catch (DestinationResolutionException e) {
                if (e.getCause() instanceof NoSuchBeanDefinitionException) {
                    this.definitionRegistry.registerBeanDefinition(inputChannelName, (BeanDefinition)new RootBeanDefinition(DirectChannel.class, DirectChannel::new));
                    inputChannel = (MessageChannel)this.beanFactory.getBean(inputChannelName, MessageChannel.class);
                }
                throw e;
            }
            Assert.notNull((Object)inputChannel, () -> "failed to resolve inputChannel '" + inputChannelName + "'");
            endpoint = this.doCreateEndpoint(handler, inputChannel, annotations);
        }
        return endpoint;
    }

    protected AbstractEndpoint doCreateEndpoint(MessageHandler handler, MessageChannel inputChannel, List<Annotation> annotations) {
        Poller poller = MessagingAnnotationUtils.resolveAttribute(annotations, "poller", Poller.class);
        Reactive reactive = MessagingAnnotationUtils.resolveAttribute(annotations, "reactive", Reactive.class);
        Assert.state((reactive == null || poller == null ? 1 : 0) != 0, (String)"The 'poller' and 'reactive' are mutually exclusive.");
        if (inputChannel instanceof Publisher || handler instanceof ReactiveMessageHandlerAdapter || reactive != null) {
            return this.reactiveStreamsConsumer(inputChannel, handler, reactive);
        }
        if (inputChannel instanceof SubscribableChannel) {
            SubscribableChannel subscribableChannel = (SubscribableChannel)inputChannel;
            Assert.state((poller == null ? 1 : 0) != 0, () -> "A '@Poller' should not be specified for Annotation-based endpoint, since '" + inputChannel + "' is a SubscribableChannel (not pollable).");
            return new EventDrivenConsumer(subscribableChannel, handler);
        }
        if (inputChannel instanceof PollableChannel) {
            return this.pollingConsumer(inputChannel, handler, poller);
        }
        throw new IllegalArgumentException("Unsupported 'inputChannel' type: '" + inputChannel.getClass().getName() + "'. Must be one of 'SubscribableChannel', 'PollableChannel' or 'ReactiveStreamsSubscribableChannel'");
    }

    private ReactiveStreamsConsumer reactiveStreamsConsumer(MessageChannel channel, MessageHandler handler, Reactive reactive) {
        String functionBeanName;
        ReactiveStreamsConsumer reactiveStreamsConsumer;
        if (handler instanceof ReactiveMessageHandlerAdapter) {
            ReactiveMessageHandlerAdapter reactiveMessageHandlerAdapter = (ReactiveMessageHandlerAdapter)handler;
            reactiveStreamsConsumer = new ReactiveStreamsConsumer(channel, reactiveMessageHandlerAdapter.getDelegate());
        } else {
            reactiveStreamsConsumer = new ReactiveStreamsConsumer(channel, handler);
        }
        if (reactive != null && StringUtils.hasText((String)(functionBeanName = reactive.value()))) {
            Function reactiveCustomizer = (Function)this.beanFactory.getBean(functionBeanName, Function.class);
            reactiveStreamsConsumer.setReactiveCustomizer(reactiveCustomizer);
        }
        return reactiveStreamsConsumer;
    }

    private PollingConsumer pollingConsumer(MessageChannel inputChannel, MessageHandler handler, Poller poller) {
        PollingConsumer pollingConsumer = new PollingConsumer((PollableChannel)inputChannel, handler);
        this.configurePollingEndpoint(pollingConsumer, poller);
        return pollingConsumer;
    }

    protected void configurePollingEndpoint(AbstractPollingEndpoint pollingEndpoint, Poller poller) {
        PollerMetadata pollerMetadata;
        if (poller != null) {
            String ref = poller.value();
            String triggerRef = poller.trigger();
            String executorRef = poller.taskExecutor();
            String fixedDelayValue = this.beanFactory.resolveEmbeddedValue(poller.fixedDelay());
            String fixedRateValue = this.beanFactory.resolveEmbeddedValue(poller.fixedRate());
            String maxMessagesPerPollValue = this.beanFactory.resolveEmbeddedValue(poller.maxMessagesPerPoll());
            String cron = this.beanFactory.resolveEmbeddedValue(poller.cron());
            String errorChannel = this.beanFactory.resolveEmbeddedValue(poller.errorChannel());
            String receiveTimeout = this.beanFactory.resolveEmbeddedValue(poller.receiveTimeout());
            if (StringUtils.hasText((String)ref)) {
                Assert.state((!StringUtils.hasText((String)triggerRef) && !StringUtils.hasText((String)executorRef) && !StringUtils.hasText((String)cron) && !StringUtils.hasText((String)fixedDelayValue) && !StringUtils.hasText((String)fixedRateValue) && !StringUtils.hasText((String)maxMessagesPerPollValue) ? 1 : 0) != 0, (String)"The '@Poller' 'ref' attribute is mutually exclusive with other attributes.");
                pollerMetadata = (PollerMetadata)this.beanFactory.getBean(ref, PollerMetadata.class);
            } else {
                pollerMetadata = this.configurePoller(pollingEndpoint, triggerRef, executorRef, fixedDelayValue, fixedRateValue, maxMessagesPerPollValue, cron, errorChannel, receiveTimeout);
            }
        } else {
            pollerMetadata = PollerMetadata.getDefaultPollerMetadata((BeanFactory)this.beanFactory);
            Assert.notNull((Object)pollerMetadata, (String)"No poller has been defined for Annotation-based endpoint, and no default poller is available within the context.");
        }
        pollingEndpoint.setTaskExecutor(pollerMetadata.getTaskExecutor());
        pollingEndpoint.setTrigger(pollerMetadata.getTrigger());
        pollingEndpoint.setAdviceChain(pollerMetadata.getAdviceChain());
        long maxMessagesPerPoll = pollerMetadata.getMaxMessagesPerPoll();
        if (maxMessagesPerPoll == Integer.MIN_VALUE && pollingEndpoint instanceof SourcePollingChannelAdapter) {
            maxMessagesPerPoll = 1L;
        }
        pollingEndpoint.setMaxMessagesPerPoll(maxMessagesPerPoll);
        pollingEndpoint.setErrorHandler(pollerMetadata.getErrorHandler());
        if (pollingEndpoint instanceof PollingConsumer) {
            PollingConsumer pollingConsumer = (PollingConsumer)pollingEndpoint;
            pollingConsumer.setReceiveTimeout(pollerMetadata.getReceiveTimeout());
        }
        pollingEndpoint.setTransactionSynchronizationFactory(pollerMetadata.getTransactionSynchronizationFactory());
    }

    private PollerMetadata configurePoller(AbstractPollingEndpoint pollingEndpoint, String triggerRef, String executorRef, String fixedDelayValue, String fixedRateValue, String maxMessagesPerPollValue, String cron, String errorChannel, String receiveTimeout) {
        PollerMetadata pollerMetadata = new PollerMetadata();
        if (StringUtils.hasText((String)maxMessagesPerPollValue)) {
            pollerMetadata.setMaxMessagesPerPoll(Long.parseLong(maxMessagesPerPollValue));
        } else if (pollingEndpoint instanceof SourcePollingChannelAdapter) {
            pollerMetadata.setMaxMessagesPerPoll(1L);
        }
        if (StringUtils.hasText((String)executorRef)) {
            pollerMetadata.setTaskExecutor((Executor)this.beanFactory.getBean(executorRef, TaskExecutor.class));
        }
        this.trigger(triggerRef, fixedDelayValue, fixedRateValue, cron, pollerMetadata);
        if (StringUtils.hasText((String)errorChannel)) {
            MessagePublishingErrorHandler errorHandler = new MessagePublishingErrorHandler();
            errorHandler.setDefaultErrorChannelName(errorChannel);
            errorHandler.setBeanFactory((BeanFactory)this.beanFactory);
            pollerMetadata.setErrorHandler(errorHandler);
        }
        if (StringUtils.hasText((String)receiveTimeout)) {
            pollerMetadata.setReceiveTimeout(Long.parseLong(receiveTimeout));
        }
        return pollerMetadata;
    }

    private void trigger(String triggerRef, String fixedDelayValue, String fixedRateValue, String cron, PollerMetadata pollerMetadata) {
        Trigger trigger2 = null;
        if (StringUtils.hasText((String)triggerRef)) {
            Assert.state((!StringUtils.hasText((String)cron) && !StringUtils.hasText((String)fixedDelayValue) && !StringUtils.hasText((String)fixedRateValue) ? 1 : 0) != 0, (String)"The '@Poller' 'trigger' attribute is mutually exclusive with other attributes.");
            trigger2 = (Trigger)this.beanFactory.getBean(triggerRef, Trigger.class);
        } else if (StringUtils.hasText((String)cron)) {
            Assert.state((!StringUtils.hasText((String)fixedDelayValue) && !StringUtils.hasText((String)fixedRateValue) ? 1 : 0) != 0, (String)"The '@Poller' 'cron' attribute is mutually exclusive with other attributes.");
            trigger2 = new CronTrigger(cron);
        } else if (StringUtils.hasText((String)fixedDelayValue) || StringUtils.hasText((String)fixedRateValue)) {
            PeriodicTriggerFactoryBean periodicTriggerFactoryBean = new PeriodicTriggerFactoryBean();
            periodicTriggerFactoryBean.setFixedDelayValue(fixedDelayValue);
            periodicTriggerFactoryBean.setFixedRateValue(fixedRateValue);
            trigger2 = periodicTriggerFactoryBean.getObject();
        }
        pollerMetadata.setTrigger(trigger2);
    }

    protected String generateHandlerBeanName(String originalBeanName, Method method) {
        return this.generateHandlerBeanName(originalBeanName, MergedAnnotations.from((AnnotatedElement)method), method.getName());
    }

    protected String generateHandlerBeanName(String originalBeanName, MergedAnnotations mergedAnnotations) {
        return this.generateHandlerBeanName(originalBeanName, mergedAnnotations, null);
    }

    protected String generateHandlerBeanName(String originalBeanName, MergedAnnotations mergedAnnotations, @Nullable String methodName) {
        Object name = MessagingAnnotationUtils.endpointIdValue(mergedAnnotations);
        if (!StringUtils.hasText((String)name)) {
            String baseName = originalBeanName + (String)(methodName != null ? "." + methodName : "") + "." + ClassUtils.getShortNameAsProperty(this.annotationType);
            name = baseName;
            int count = 1;
            while (this.beanFactory.containsBean((String)name)) {
                name = baseName + "#" + ++count;
            }
        }
        return (String)name + ".handler";
    }

    protected static void setOutputChannelIfPresent(List<Annotation> annotations, AbstractMessageProducingHandler handler) {
        String outputChannel = MessagingAnnotationUtils.resolveAttribute(annotations, "outputChannel", String.class);
        if (StringUtils.hasText((String)outputChannel)) {
            handler.setOutputChannelName(outputChannel);
        }
    }

    protected void checkMessageHandlerAttributes(String handlerBeanName, List<Annotation> annotations) {
        for (String attribute : this.messageHandlerAttributes) {
            for (Annotation annotation : annotations) {
                Object value = AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
                if (!MessagingAnnotationUtils.hasValue(value)) continue;
                throw new BeanDefinitionValidationException("The MessageHandler [" + handlerBeanName + "] can not be populated because of ambiguity with annotation attributes " + this.messageHandlerAttributes + " which are not allowed when an integration annotation is used with a @Bean definition for a MessageHandler.\nThe attribute causing the ambiguity is: [" + attribute + "].\nUse the appropriate setter on the MessageHandler directly when configuring an endpoint this way.");
            }
        }
    }

    protected boolean resolveAttributeToBoolean(String attribute) {
        return Boolean.parseBoolean(this.beanFactory.resolveEmbeddedValue(attribute));
    }

    protected static BeanDefinition buildLambdaMessageProcessor(ResolvableType beanType, AnnotatedBeanDefinition beanDefinition) {
        Class beanClass = beanType.toClass();
        if (Function.class.isAssignableFrom(beanClass) || Consumer.class.isAssignableFrom(beanClass) || org.springframework.integration.util.ClassUtils.isKotlinFunction1(beanClass)) {
            Class expectedPayloadType = beanType.getGeneric(new int[]{0}).toClass();
            return BeanDefinitionBuilder.genericBeanDefinition(LambdaMessageProcessor.class).addConstructorArgValue((Object)beanDefinition).addConstructorArgValue((Object)expectedPayloadType).getBeanDefinition();
        }
        return null;
    }

    private static void orderable(Method method, MessageHandler handler) {
        if (handler instanceof Orderable) {
            Orderable orderable = (Orderable)handler;
            Order orderAnnotation = (Order)AnnotationUtils.findAnnotation((Method)method, Order.class);
            if (orderAnnotation != null) {
                orderable.setOrder(orderAnnotation.value());
            }
        }
    }

    protected abstract MessageHandler createHandler(Object var1, Method var2, List<Annotation> var3);

    protected record BeanDefinitionPropertiesMapper(BeanDefinition beanDefinition, List<Annotation> annotations) {
        public BeanDefinitionPropertiesMapper setPropertyValue(String property) {
            return this.setPropertyValue(property, null);
        }

        public BeanDefinitionPropertiesMapper setPropertyValue(String property, @Nullable String propertyName) {
            String value = MessagingAnnotationUtils.resolveAttribute(this.annotations, property, String.class);
            if (StringUtils.hasText((String)value)) {
                this.beanDefinition.getPropertyValues().add(propertyName != null ? propertyName : property, (Object)value);
            }
            return this;
        }

        public BeanDefinitionPropertiesMapper setPropertyReference(String property) {
            return this.setPropertyReference(property, null);
        }

        public BeanDefinitionPropertiesMapper setPropertyReference(String property, @Nullable String propertyName) {
            String value = MessagingAnnotationUtils.resolveAttribute(this.annotations, property, String.class);
            if (StringUtils.hasText((String)value)) {
                this.beanDefinition.getPropertyValues().add(propertyName != null ? propertyName : property, (Object)new RuntimeBeanReference(value));
            }
            return this;
        }
    }
}

