/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.context;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionOverrideException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FixedSubscriberChannel;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.SourcePollingChannelAdapterFactoryBean;
import org.springframework.integration.context.ComponentSourceAware;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.ConsumerEndpointSpec;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowAdapter;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.integration.dsl.context.IntegrationFlowLifecycleAdvice;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.gateway.AnnotationGatewayProxyFactoryBean;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import reactor.util.function.Tuple2;

public class IntegrationFlowBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
SmartInitializingSingleton,
AopInfrastructureBean {
    private ConfigurableApplicationContext applicationContext;
    private StringValueResolver embeddedValueResolver;
    private DefaultListableBeanFactory beanFactory;
    private volatile IntegrationFlowContext flowContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext, (String)"To use Spring Integration Java DSL the 'applicationContext' has to be an instance of 'ConfigurableApplicationContext'. Consider using 'GenericApplicationContext' implementation.");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        this.beanFactory = (DefaultListableBeanFactory)this.applicationContext.getBeanFactory();
        this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)this.beanFactory);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof StandardIntegrationFlow) {
            StandardIntegrationFlow standardIntegrationFlow = (StandardIntegrationFlow)bean;
            return this.processStandardIntegrationFlow(standardIntegrationFlow, beanName);
        }
        if (bean instanceof IntegrationFlow) {
            IntegrationFlow integrationFlow2 = (IntegrationFlow)bean;
            return this.processIntegrationFlowImpl(integrationFlow2, beanName);
        }
        if (bean instanceof IntegrationComponentSpec) {
            IntegrationComponentSpec integrationComponentSpec = (IntegrationComponentSpec)bean;
            this.processIntegrationComponentSpec(beanName, integrationComponentSpec);
        }
        return bean;
    }

    public void afterSingletonsInstantiated() {
        for (String beanName : this.beanFactory.getBeanNamesForType(IntegrationFlow.class)) {
            String scope;
            if (!this.beanFactory.containsBeanDefinition(beanName) || !StringUtils.hasText((String)(scope = this.beanFactory.getBeanDefinition(beanName).getScope())) || "singleton".equals(scope)) continue;
            throw new BeanCreationNotAllowedException(beanName, "IntegrationFlows can not be scoped beans. Any dependant beans are registered as singletons, meanwhile IntegrationFlow is just a logical container for them. \nConsider using [IntegrationFlowContext] for manual registration of IntegrationFlows.");
        }
    }

    private Object processStandardIntegrationFlow(StandardIntegrationFlow flow, String flowBeanName) {
        boolean registerBeanDefinitions = this.beanFactory.containsBeanDefinition(flowBeanName);
        if (registerBeanDefinitions) {
            BeanDefinition beanDefinition2 = this.beanFactory.getBeanDefinition(flowBeanName);
            flow.setComponentSource(beanDefinition2.getSource());
            flow.setComponentDescription(beanDefinition2.getDescription());
        }
        Object beanSource = flow.getComponentSource();
        String beanDescription = flow.getComponentDescription();
        String flowNamePrefix = flowBeanName + ".";
        if (this.flowContext == null) {
            this.flowContext = (IntegrationFlowContext)this.beanFactory.getBean(IntegrationFlowContext.class);
        }
        boolean useFlowIdAsPrefix = this.flowContext.isUseIdAsPrefix(flowBeanName);
        int subFlowNameIndex = 0;
        int channelNameIndex = 0;
        Map<Object, String> integrationComponents = flow.getIntegrationComponents();
        LinkedHashMap<Object, String> targetIntegrationComponents = new LinkedHashMap<Object, String>(integrationComponents.size());
        for (Map.Entry<Object, String> entry : integrationComponents.entrySet()) {
            Object id;
            Object component = entry.getKey();
            if (component instanceof ConsumerEndpointSpec) {
                ConsumerEndpointSpec endpointSpec = (ConsumerEndpointSpec)component;
                MessageHandler messageHandler = (MessageHandler)((Tuple2)endpointSpec.getObject()).getT2();
                ConsumerEndpointFactoryBean endpoint = (ConsumerEndpointFactoryBean)((Tuple2)endpointSpec.getObject()).getT1();
                id = endpointSpec.getId();
                if (id == null) {
                    id = this.generateBeanName(endpoint, flowNamePrefix, entry.getValue(), useFlowIdAsPrefix);
                } else if (useFlowIdAsPrefix) {
                    id = flowNamePrefix + (String)id;
                }
                if (this.noBeanPresentForComponent(messageHandler, flowBeanName)) {
                    String handlerBeanName = this.generateBeanName(messageHandler, flowNamePrefix);
                    this.registerComponent(registerBeanDefinitions, messageHandler, handlerBeanName, beanSource, beanDescription, flowBeanName);
                    this.beanFactory.registerAlias(handlerBeanName, (String)id + ".handler");
                }
                this.registerComponent(registerBeanDefinitions, endpoint, (String)id, beanSource, beanDescription, flowBeanName);
                targetIntegrationComponents.put(endpoint, (String)id);
                continue;
            }
            if (component instanceof MessageChannelReference) {
                DirectChannel channelByName;
                MessageChannelReference messageChannelReference = (MessageChannelReference)component;
                String channelBeanName = messageChannelReference.name();
                if (!this.beanFactory.containsBean(channelBeanName)) {
                    channelByName = new DirectChannel();
                    this.registerComponent(registerBeanDefinitions, channelByName, channelBeanName, beanSource, beanDescription, flowBeanName);
                } else {
                    channelByName = (MessageChannel)this.beanFactory.getBean(channelBeanName, MessageChannel.class);
                }
                targetIntegrationComponents.put(channelByName, channelBeanName);
                continue;
            }
            if (component instanceof SourcePollingChannelAdapterSpec) {
                NamedComponent namedComponent;
                SourcePollingChannelAdapterSpec spec = (SourcePollingChannelAdapterSpec)component;
                Map<Object, String> componentsToRegister = spec.getComponentsToRegister();
                if (!CollectionUtils.isEmpty(componentsToRegister)) {
                    componentsToRegister.entrySet().stream().filter(o -> this.noBeanPresentForComponent(o.getKey(), flowBeanName)).forEach(o -> this.registerComponent(registerBeanDefinitions, o.getKey(), this.generateBeanName(o.getKey(), flowNamePrefix, (String)o.getValue(), useFlowIdAsPrefix), beanSource, beanDescription, spec.getId()));
                }
                SourcePollingChannelAdapterFactoryBean pollingChannelAdapterFactoryBean = (SourcePollingChannelAdapterFactoryBean)((Tuple2)spec.getObject()).getT1();
                id = spec.getId();
                if (id == null) {
                    id = this.generateBeanName(pollingChannelAdapterFactoryBean, flowNamePrefix, entry.getValue(), useFlowIdAsPrefix);
                } else if (useFlowIdAsPrefix) {
                    id = flowNamePrefix + (String)id;
                }
                this.registerComponent(registerBeanDefinitions, pollingChannelAdapterFactoryBean, (String)id, beanSource, beanDescription, flowBeanName);
                targetIntegrationComponents.put(pollingChannelAdapterFactoryBean, (String)id);
                MessageSource messageSource = (MessageSource)((Tuple2)spec.getObject()).getT2();
                if (!this.noBeanPresentForComponent(messageSource, flowBeanName)) continue;
                Object messageSourceId = (String)id + ".source";
                if (messageSource instanceof NamedComponent && (namedComponent = (NamedComponent)((Object)messageSource)).getComponentName() != null) {
                    messageSourceId = namedComponent.getComponentName();
                }
                this.registerComponent(registerBeanDefinitions, messageSource, (String)messageSourceId, beanSource, beanDescription, flowBeanName);
                continue;
            }
            if (this.noBeanPresentForComponent(component, flowBeanName)) {
                Object channelBeanName;
                if (component instanceof AbstractMessageChannel || component instanceof NullChannel) {
                    channelBeanName = ((NamedComponent)component).getComponentName();
                    if (channelBeanName == null && (channelBeanName = entry.getValue()) == null) {
                        channelBeanName = flowNamePrefix + "channel#" + channelNameIndex++;
                    }
                    this.registerComponent(registerBeanDefinitions, component, (String)channelBeanName, beanSource, beanDescription, flowBeanName);
                    targetIntegrationComponents.put(component, (String)channelBeanName);
                    continue;
                }
                if (component instanceof FixedSubscriberChannel) {
                    FixedSubscriberChannel fixedSubscriberChannel = (FixedSubscriberChannel)component;
                    channelBeanName = fixedSubscriberChannel.getComponentName();
                    if ("Unnamed fixed subscriber channel".equals(channelBeanName)) {
                        channelBeanName = flowNamePrefix + "channel#" + channelNameIndex++;
                    }
                    this.registerComponent(registerBeanDefinitions, component, (String)channelBeanName, beanSource, beanDescription, flowBeanName);
                    targetIntegrationComponents.put(component, (String)channelBeanName);
                    continue;
                }
                if (component instanceof StandardIntegrationFlow) {
                    Object subFlowBeanName = entry.getValue() != null ? entry.getValue() : flowNamePrefix + "subFlow#" + subFlowNameIndex++;
                    this.registerComponent(registerBeanDefinitions, component, (String)subFlowBeanName, beanSource, beanDescription, flowBeanName);
                    targetIntegrationComponents.put(component, (String)subFlowBeanName);
                    continue;
                }
                if (component instanceof AnnotationGatewayProxyFactoryBean) {
                    AnnotationGatewayProxyFactoryBean gateway2 = (AnnotationGatewayProxyFactoryBean)component;
                    Object gatewayId = entry.getValue();
                    if (gatewayId == null) {
                        gatewayId = gateway2.getComponentName();
                    }
                    if (gatewayId == null) {
                        gatewayId = flowNamePrefix + "gateway";
                    }
                    if (registerBeanDefinitions) {
                        this.registerBeanDefinition(gateway2, (String)gatewayId, beanSource, beanDescription, flowBeanName, beanDefinition -> {
                            RootBeanDefinition definition = (RootBeanDefinition)beanDefinition;
                            Class<?> serviceInterface = gateway2.getObjectType();
                            definition.setSource((Object)new DescriptiveResource("" + serviceInterface));
                            definition.setTargetType(ResolvableType.forClassWithGenerics(AnnotationGatewayProxyFactoryBean.class, (Class[])new Class[]{serviceInterface}));
                        });
                    } else {
                        this.registerSingleton(gateway2, (String)gatewayId, beanSource, beanDescription, flowBeanName);
                    }
                    targetIntegrationComponents.put(component, (String)gatewayId);
                    continue;
                }
                String generatedBeanName = this.generateBeanName(component, flowNamePrefix, entry.getValue(), useFlowIdAsPrefix);
                this.registerComponent(registerBeanDefinitions, component, generatedBeanName, beanSource, beanDescription, flowBeanName);
                targetIntegrationComponents.put(component, generatedBeanName);
                continue;
            }
            Object componentToUse = entry.getKey();
            String beanNameToUse = entry.getValue();
            if (StringUtils.hasText((String)beanNameToUse) && "prototype".equals(IntegrationContextUtils.getBeanDefinition(beanNameToUse, (ConfigurableListableBeanFactory)this.beanFactory).getScope())) {
                this.beanFactory.initializeBean(componentToUse, beanNameToUse);
            }
            targetIntegrationComponents.put(component, beanNameToUse);
        }
        flow.setIntegrationComponents(targetIntegrationComponents);
        return flow;
    }

    private Object processIntegrationFlowImpl(IntegrationFlow flow, String beanName) {
        IntegrationFlowBuilder flowBuilder2 = IntegrationFlow.from(beanName + ".input");
        flow.configure(flowBuilder2);
        StandardIntegrationFlow target = flowBuilder2.get();
        this.processStandardIntegrationFlow(target, beanName);
        if (!(flow instanceof IntegrationFlowAdapter)) {
            NameMatchMethodPointcutAdvisor integrationFlowAdvice = new NameMatchMethodPointcutAdvisor((Advice)new IntegrationFlowLifecycleAdvice(target));
            integrationFlowAdvice.setMappedNames(new String[]{"getInputChannel", "getIntegrationComponents", "start", "stop", "isRunning", "isAutoStartup", "getPhase"});
            ProxyFactory proxyFactory = new ProxyFactory((Object)flow);
            proxyFactory.addAdvisor((Advisor)integrationFlowAdvice);
            if (!(flow instanceof SmartLifecycle)) {
                proxyFactory.addInterface(SmartLifecycle.class);
            }
            return proxyFactory.getProxy(this.beanFactory.getBeanClassLoader());
        }
        return flow;
    }

    private void processIntegrationComponentSpec(String beanName, IntegrationComponentSpec<?, ?> bean) {
        ComponentsRegistration componentsRegistration;
        Map<Object, String> componentsToRegister;
        Object target = bean.getObject();
        this.invokeBeanInitializationHooks(beanName, target);
        if (bean instanceof ComponentsRegistration && !CollectionUtils.isEmpty(componentsToRegister = (componentsRegistration = (ComponentsRegistration)((Object)bean)).getComponentsToRegister())) {
            boolean registerBeanDefinitions = this.beanFactory.containsBeanDefinition(beanName);
            BeanDefinition beanDefinition = null;
            if (registerBeanDefinitions) {
                beanDefinition = this.beanFactory.getBeanDefinition(beanName);
            }
            Object beanDefinitionSource = registerBeanDefinitions ? beanDefinition.getSource() : null;
            String beanDefinitionDescription = registerBeanDefinitions ? beanDefinition.getDescription() : null;
            componentsToRegister.entrySet().stream().filter(component -> this.noBeanPresentForComponent(component.getKey(), beanName)).forEach(component -> this.registerComponent(registerBeanDefinitions, component.getKey(), this.generateBeanName(component.getKey(), beanName, (String)component.getValue(), false), beanDefinitionSource, beanDefinitionDescription, beanName));
        }
    }

    private void invokeBeanInitializationHooks(String beanName, Object bean) {
        if (bean instanceof Aware) {
            if (bean instanceof BeanNameAware) {
                BeanNameAware beanNameAware = (BeanNameAware)bean;
                beanNameAware.setBeanName(beanName);
            }
            if (bean instanceof BeanClassLoaderAware) {
                BeanClassLoaderAware beanClassLoaderAware = (BeanClassLoaderAware)bean;
                if (this.beanFactory.getBeanClassLoader() != null) {
                    beanClassLoaderAware.setBeanClassLoader(this.beanFactory.getBeanClassLoader());
                }
            }
            if (bean instanceof BeanFactoryAware) {
                BeanFactoryAware beanFactoryAware = (BeanFactoryAware)bean;
                beanFactoryAware.setBeanFactory((BeanFactory)this.beanFactory);
            }
            if (bean instanceof EnvironmentAware) {
                EnvironmentAware environmentAware = (EnvironmentAware)bean;
                environmentAware.setEnvironment((Environment)this.applicationContext.getEnvironment());
            }
            if (bean instanceof EmbeddedValueResolverAware) {
                EmbeddedValueResolverAware embeddedValueResolverAware = (EmbeddedValueResolverAware)bean;
                embeddedValueResolverAware.setEmbeddedValueResolver(this.embeddedValueResolver);
            }
            if (bean instanceof ResourceLoaderAware) {
                ResourceLoaderAware resourceLoaderAware = (ResourceLoaderAware)bean;
                resourceLoaderAware.setResourceLoader((ResourceLoader)this.applicationContext);
            }
            if (bean instanceof ApplicationEventPublisherAware) {
                ApplicationEventPublisherAware eventPublisherAware = (ApplicationEventPublisherAware)bean;
                eventPublisherAware.setApplicationEventPublisher((ApplicationEventPublisher)this.applicationContext);
            }
            if (bean instanceof MessageSourceAware) {
                MessageSourceAware messageSourceAware = (MessageSourceAware)bean;
                messageSourceAware.setMessageSource((org.springframework.context.MessageSource)this.applicationContext);
            }
            if (bean instanceof ApplicationContextAware) {
                ApplicationContextAware applicationContextAware = (ApplicationContextAware)bean;
                applicationContextAware.setApplicationContext((ApplicationContext)this.applicationContext);
            }
        }
    }

    private boolean noBeanPresentForComponent(Object instance, String parentBeanName) {
        if (instance instanceof NamedComponent) {
            Object existingBean;
            NamedComponent namedComponent = (NamedComponent)instance;
            String beanName = namedComponent.getBeanName();
            if (beanName == null || !this.beanFactory.containsBean(beanName)) {
                return true;
            }
            BeanDefinition existingBeanDefinition = null;
            try {
                existingBeanDefinition = IntegrationContextUtils.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)this.beanFactory);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            if (!(existingBeanDefinition != null && "prototype".equals(existingBeanDefinition.getScope()) || instance.equals(existingBean = this.beanFactory.getBean(beanName)))) {
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(instance.getClass(), () -> instance).getBeanDefinition();
                beanDefinition.setResourceDescription("the '" + parentBeanName + "' bean definition");
                if (existingBeanDefinition == null) {
                    existingBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(existingBean.getClass(), () -> existingBean).getBeanDefinition();
                }
                throw new BeanDefinitionOverrideException(beanName, (BeanDefinition)beanDefinition, existingBeanDefinition);
            }
            return false;
        }
        return !this.beanFactory.getBeansOfType(instance.getClass(), false, false).containsValue(instance);
    }

    private void registerComponent(boolean registerBeanDefinition, Object component, String beanName, @Nullable Object source, @Nullable String description, @Nullable String parentName) {
        if (registerBeanDefinition) {
            this.registerBeanDefinition(component, beanName, source, description, parentName, new BeanDefinitionCustomizer[0]);
        } else {
            this.registerSingleton(component, beanName, source, description, parentName);
        }
    }

    private void registerBeanDefinition(Object component, String beanName, @Nullable Object source, @Nullable String description, @Nullable String parentName, BeanDefinitionCustomizer ... customizers) {
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(component.getClass(), () -> component).applyCustomizers(customizers).getRawBeanDefinition();
        beanDefinition.setSource(source);
        beanDefinition.setDescription(description);
        if (parentName != null) {
            this.beanFactory.registerDependentBean(parentName, beanName);
        }
        this.beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        this.beanFactory.getBean(beanName);
    }

    private void registerSingleton(Object component, String beanName, @Nullable Object source, @Nullable String description, @Nullable String parentName) {
        if (component instanceof ComponentSourceAware) {
            ComponentSourceAware componentSourceAware = (ComponentSourceAware)component;
            componentSourceAware.setComponentSource(source);
            componentSourceAware.setComponentDescription(description);
        }
        if (parentName != null) {
            this.beanFactory.registerDependentBean(parentName, beanName);
        }
        this.beanFactory.registerSingleton(beanName, component);
        this.beanFactory.initializeBean(component, beanName);
        this.beanFactory.getBean(beanName);
    }

    private String generateBeanName(Object instance, String prefix) {
        return this.generateBeanName(instance, prefix, null, false);
    }

    private String generateBeanName(Object instance, String prefix, @Nullable String fallbackId, boolean useFlowIdAsPrefix) {
        NamedComponent namedComponent;
        if (instance instanceof NamedComponent && (namedComponent = (NamedComponent)instance).getBeanName() != null) {
            String beanName = namedComponent.getBeanName();
            return useFlowIdAsPrefix ? prefix + beanName : beanName;
        }
        if (fallbackId != null) {
            return useFlowIdAsPrefix ? prefix + fallbackId : fallbackId;
        }
        Object generatedBeanName = prefix;
        if (instance instanceof NamedComponent) {
            NamedComponent namedComponent2 = (NamedComponent)instance;
            generatedBeanName = (String)generatedBeanName + namedComponent2.getComponentType();
        } else {
            generatedBeanName = (String)generatedBeanName + instance.getClass().getName();
        }
        Object id = generatedBeanName;
        int counter = -1;
        while (counter == -1 || this.beanFactory.containsBean((String)id)) {
            id = (String)generatedBeanName + "#" + ++counter;
        }
        return id;
    }
}

