/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.support.management.ControlBusMethodFilter;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ControlBusCommandRegistry
implements ApplicationContextAware,
SmartInitializingSingleton,
DestructionAwareBeanPostProcessor {
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^@?'?(?<beanName>.[^']+)'?\\.(?<methodName>[a-zA-Z0-9_]+)\\(?\\)?$");
    private static final ExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private static final ControlBusMethodFilter CONTROL_BUS_METHOD_FILTER = new ControlBusMethodFilter();
    private final Map<String, Map<CommandMethod, Expression>> controlBusCommands = new HashMap<String, Map<CommandMethod, Expression>>();
    private boolean eagerInitialization;
    private ApplicationContext applicationContext;
    private boolean initialized;

    public void setEagerInitialization(boolean eagerInitialization) {
        this.eagerInitialization = eagerInitialization;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterSingletonsInstantiated() {
        if (this.eagerInitialization) {
            this.applicationContext.getBeansOfType(null).forEach(this::registerControlBusCommands);
            this.initialized = true;
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.initialized) {
            this.registerControlBusCommands(beanName, bean);
        }
        return bean;
    }

    public void registerControlBusCommands(String beanName, Object bean) {
        Class<?> beanClass = bean.getClass();
        if (bean instanceof Lifecycle || bean instanceof CustomizableThreadCreator || AnnotationUtils.findAnnotation(beanClass, ManagedResource.class) != null || AnnotationUtils.findAnnotation(beanClass, IntegrationManagedResource.class) != null) {
            ReflectionUtils.doWithMethods(beanClass, method -> this.populateExpressionForCommand(beanName, method), (ReflectionUtils.MethodFilter)CONTROL_BUS_METHOD_FILTER);
        }
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        this.controlBusCommands.remove(beanName);
    }

    public Map<String, Map<CommandMethod, String>> getCommands() {
        HashMap<String, Map<CommandMethod, String>> commands = new HashMap<String, Map<CommandMethod, String>>(this.controlBusCommands.size());
        for (Map.Entry<String, Map<CommandMethod, Expression>> beanEntry : this.controlBusCommands.entrySet()) {
            Map<CommandMethod, String> commandEntries = beanEntry.getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, commandEntry -> ((Expression)commandEntry.getValue()).getExpressionString()));
            commands.put(beanEntry.getKey(), commandEntries);
        }
        return Collections.unmodifiableMap(commands);
    }

    public Expression getExpressionForCommand(String command, Class<?> ... parameterTypes) {
        Matcher matcher = COMMAND_PATTERN.matcher(command);
        Assert.isTrue((boolean)matcher.matches(), (String)"The command must be in format 'beanName.methodName'. Arguments must go to the 'controlBusArguments' message header.");
        String beanName = matcher.group("beanName");
        Assert.isTrue((boolean)this.applicationContext.containsBean(beanName), () -> "There is no registered bean for requested command: " + beanName);
        String methodName = matcher.group("methodName");
        CommandMethod commandMethod = new CommandMethod(beanName, methodName, parameterTypes);
        return this.populateCommandMethod(commandMethod, key -> this.buildExpressionForMethodToCall(commandMethod));
    }

    private void populateExpressionForCommand(String beanName, Method methodForCommand) {
        CommandMethod commandMethod = new CommandMethod(beanName, methodForCommand.getName(), methodForCommand.getParameterTypes());
        this.populateCommandMethod(commandMethod, key -> ControlBusCommandRegistry.buildExpressionForMethodToCall(commandMethod, methodForCommand));
    }

    private Expression populateCommandMethod(CommandMethod commandMethod, Function<CommandMethod, Expression> mappingFunction) {
        String beanName = commandMethod.beanName;
        Map beanControlBusCommands = this.controlBusCommands.computeIfAbsent(beanName, key -> new HashMap());
        try {
            return beanControlBusCommands.computeIfAbsent(commandMethod, mappingFunction);
        }
        catch (IllegalArgumentException ex) {
            if (beanControlBusCommands.isEmpty()) {
                this.controlBusCommands.remove(beanName);
            }
            throw ex;
        }
    }

    private Expression buildExpressionForMethodToCall(CommandMethod commandMethod) {
        Object bean = this.applicationContext.getBean(commandMethod.beanName);
        Set candidates = MethodIntrospector.selectMethods(bean.getClass(), method -> commandMethod.methodName.equals(method.getName()));
        Optional<Method> methodForCommand = candidates.stream().filter(method -> ControlBusCommandRegistry.areParameterTypesEqual(method.getParameterTypes(), commandMethod.parameterTypes)).findFirst();
        Assert.isTrue((boolean)methodForCommand.isPresent(), () -> "No method '%s' found in bean '%s' for parameter types '%s'".formatted(commandMethod.methodName, bean, Arrays.toString(commandMethod.parameterTypes)));
        return ControlBusCommandRegistry.buildExpressionForMethodToCall(commandMethod, methodForCommand.get());
    }

    private static Expression buildExpressionForMethodToCall(CommandMethod commandMethod, Method methodForCommand) {
        Assert.isTrue((boolean)CONTROL_BUS_METHOD_FILTER.matches(methodForCommand), () -> "The method '%s' is not valid Control Bus command".formatted(methodForCommand));
        ControlBusCommandRegistry.populateDescriptionIntoCommand(commandMethod, methodForCommand);
        Class<?>[] parameterTypes = methodForCommand.getParameterTypes();
        StringBuilder expressionBuilder = new StringBuilder("@'").append(commandMethod.beanName).append("'.").append(methodForCommand.getName()).append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            expressionBuilder.append('[').append(i).append("],");
        }
        if (parameterTypes.length > 0) {
            expressionBuilder.deleteCharAt(expressionBuilder.length() - 1);
        }
        String expression = expressionBuilder.append(')').toString();
        return EXPRESSION_PARSER.parseExpression(expression);
    }

    private static boolean areParameterTypesEqual(Class<?>[] lhsTypes, Class<?>[] rhsTypes) {
        if (lhsTypes.length == rhsTypes.length) {
            for (int i = 0; i < lhsTypes.length; ++i) {
                if (ClassUtils.isAssignable(lhsTypes[i], rhsTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void populateDescriptionIntoCommand(CommandMethod commandMethod, Method methodForCommand) {
        ManagedOperation managedOperation = (ManagedOperation)AnnotationUtils.findAnnotation((Method)methodForCommand, ManagedOperation.class);
        if (managedOperation != null) {
            commandMethod.description = managedOperation.description();
        } else {
            ManagedAttribute managedAttribute = (ManagedAttribute)AnnotationUtils.findAnnotation((Method)methodForCommand, ManagedAttribute.class);
            if (managedAttribute != null) {
                commandMethod.description = managedAttribute.description();
            }
        }
        if (!StringUtils.hasText((String)commandMethod.description)) {
            commandMethod.description = commandMethod.methodName;
        }
    }

    public static final class CommandMethod {
        private final String beanName;
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private String description;

        private CommandMethod(String beanName, String methodName, Class<?>[] parameterTypes) {
            this.beanName = beanName;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int result = Objects.hash(this.beanName, this.methodName);
            result = 31 * result + Arrays.hashCode(this.parameterTypes);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandMethod that = (CommandMethod)o;
            return Objects.equals(this.beanName, that.beanName) && Objects.equals(this.methodName, that.methodName) && ControlBusCommandRegistry.areParameterTypesEqual(this.parameterTypes, that.parameterTypes);
        }
    }
}

