/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.kafka.support.KafkaProducerContext;
import org.springframework.integration.kafka.support.ProducerConfiguration;
import org.springframework.integration.kafka.support.ProducerFactoryBean;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.integration.kafka.util.EncoderAdaptingSerializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class KafkaProducerContextParser
extends AbstractSimpleBeanDefinitionParser {
    private static final Log log = LogFactory.getLog(KafkaProducerContextParser.class);

    protected Class<?> getBeanClass(Element element) {
        return KafkaProducerContext.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        Element topics = DomUtils.getChildElementByTagName((Element)element, (String)"producer-configurations");
        this.parseProducerConfigurations(topics, parserContext, builder, element);
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !"producer-properties".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    private void parseProducerConfigurations(Element topics, ParserContext parserContext, BeanDefinitionBuilder builder, Element parentElem) {
        ManagedMap producerConfigurationsMap = new ManagedMap();
        for (Element producerConfiguration : DomUtils.getChildElementsByTagName((Element)topics, (String)"producer-configuration")) {
            BeanDefinitionBuilder producerMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProducerMetadata.class);
            producerMetadataBuilder.addConstructorArgValue((Object)producerConfiguration.getAttribute("topic"));
            producerMetadataBuilder.addConstructorArgValue((Object)producerConfiguration.getAttribute("key-class-type"));
            producerMetadataBuilder.addConstructorArgValue((Object)producerConfiguration.getAttribute("value-class-type"));
            String keySerializer = producerConfiguration.getAttribute("key-serializer");
            String keyEncoder = producerConfiguration.getAttribute("key-encoder");
            Assert.isTrue((boolean)(StringUtils.hasText((String)keySerializer) ^ StringUtils.hasText((String)keyEncoder)), (String)"Exactly one of 'key-serializer' or 'key-encoder' must be specified");
            if (StringUtils.hasText((String)keyEncoder)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"'key-encoder' is a deprecated option, use 'key-serializer' instead.");
                }
                BeanDefinitionBuilder encoderAdaptingSerializerBean = BeanDefinitionBuilder.genericBeanDefinition(EncoderAdaptingSerializer.class);
                encoderAdaptingSerializerBean.addConstructorArgReference(keyEncoder);
                producerMetadataBuilder.addConstructorArgValue((Object)encoderAdaptingSerializerBean.getBeanDefinition());
            } else {
                producerMetadataBuilder.addConstructorArgReference(keySerializer);
            }
            String valueSerializer = producerConfiguration.getAttribute("value-serializer");
            String valueEncoder = producerConfiguration.getAttribute("value-encoder");
            Assert.isTrue((boolean)(StringUtils.hasText((String)valueSerializer) ^ StringUtils.hasText((String)valueEncoder)), (String)"Exactly one of 'value-serializer' or 'value-encoder' must be specified");
            if (StringUtils.hasText((String)valueEncoder)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"'value-encoder' is a deprecated option, use 'value-serializer' instead.");
                }
                BeanDefinitionBuilder encoderAdaptingSerializerBean = BeanDefinitionBuilder.genericBeanDefinition(EncoderAdaptingSerializer.class);
                encoderAdaptingSerializerBean.addConstructorArgReference(valueEncoder);
                producerMetadataBuilder.addConstructorArgValue((Object)encoderAdaptingSerializerBean.getBeanDefinition());
            } else {
                producerMetadataBuilder.addConstructorArgReference(valueSerializer);
            }
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"partitioner");
            if (StringUtils.hasText((String)producerConfiguration.getAttribute("partitioner")) && log.isWarnEnabled()) {
                log.warn((Object)"'partitioner' is a deprecated option. Use the 'kafka_partitionId' message header or the partition argument in the send() or convertAndSend() methods");
            }
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"compression-type");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"batch-bytes");
            AbstractBeanDefinition producerMetadataBeanDefinition = producerMetadataBuilder.getBeanDefinition();
            String producerPropertiesBean = parentElem.getAttribute("producer-properties");
            BeanDefinitionBuilder producerFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProducerFactoryBean.class);
            producerFactoryBuilder.addConstructorArgValue((Object)producerMetadataBeanDefinition);
            String brokerList = producerConfiguration.getAttribute("broker-list");
            if (StringUtils.hasText((String)brokerList)) {
                producerFactoryBuilder.addConstructorArgValue((Object)producerConfiguration.getAttribute("broker-list"));
            }
            if (StringUtils.hasText((String)producerPropertiesBean)) {
                producerFactoryBuilder.addConstructorArgReference(producerPropertiesBean);
            }
            AbstractBeanDefinition producerFactoryBeanDefinition = producerFactoryBuilder.getBeanDefinition();
            BeanDefinitionBuilder producerConfigurationBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProducerConfiguration.class).addConstructorArgValue((Object)producerMetadataBeanDefinition).addConstructorArgValue((Object)producerFactoryBeanDefinition);
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)producerConfigurationBuilder, (Element)producerConfiguration, (String)"conversion-service");
            producerConfigurationsMap.put(producerConfiguration.getAttribute("topic"), producerConfigurationBuilder.getBeanDefinition());
        }
        builder.addPropertyValue("producerConfigurations", (Object)producerConfigurationsMap);
    }
}

