/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.integration.kafka.core.Partition;

public class Result<T> {
    private final Map<Partition, T> results;
    private final Map<Partition, Short> errors;

    Result(Map<Partition, T> results, Map<Partition, Short> errors) {
        this.results = Collections.unmodifiableMap(results);
        this.errors = Collections.unmodifiableMap(errors);
    }

    public Map<Partition, T> getResults() {
        return this.results;
    }

    public T getResult(Partition partition) throws IllegalArgumentException {
        if (this.results.containsKey(partition)) {
            return this.results.get(partition);
        }
        throw new IllegalArgumentException(" No result received for " + partition.toString());
    }

    public Map<Partition, Short> getErrors() {
        return this.errors;
    }

    public short getError(Partition partition) throws IllegalArgumentException {
        if (this.getErrors().containsKey(partition)) {
            return this.getErrors().get(partition);
        }
        throw new IllegalArgumentException("No error received for " + partition.toString());
    }
}

