/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.kafka.support.ProducerConfiguration;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.util.StringUtils;

public class KafkaProducerContext
implements SmartLifecycle,
NamedComponent,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(KafkaProducerContext.class);
    private final AtomicBoolean running = new AtomicBoolean();
    private volatile Map<String, ProducerConfiguration<?, ?>> producerConfigurations;
    private volatile ProducerConfiguration<?, ?> theProducerConfiguration;
    private String beanName = "not_specified";
    private int phase = 0;
    private boolean autoStartup = true;

    public ProducerConfiguration<?, ?> getTopicConfiguration(String topic) {
        if (this.theProducerConfiguration != null && topic.matches(this.theProducerConfiguration.getProducerMetadata().getTopic())) {
            return this.theProducerConfiguration;
        }
        Collection<ProducerConfiguration<?, ?>> topics = this.producerConfigurations.values();
        for (ProducerConfiguration<?, ?> producerConfiguration : topics) {
            if (!topic.matches(producerConfiguration.getProducerMetadata().getTopic())) continue;
            return producerConfiguration;
        }
        return null;
    }

    public Map<String, ProducerConfiguration<?, ?>> getProducerConfigurations() {
        return this.producerConfigurations;
    }

    public void setProducerConfigurations(Map<String, ProducerConfiguration<?, ?>> producerConfigurations) {
        this.producerConfigurations = producerConfigurations;
        if (this.producerConfigurations.size() == 1) {
            this.theProducerConfiguration = this.producerConfigurations.values().iterator().next();
        }
    }

    public String getComponentType() {
        return "kafka:producer-context";
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public String getComponentName() {
        return this.beanName;
    }

    protected void doStart() {
    }

    protected void doStop() {
        if (this.producerConfigurations != null) {
            for (ProducerConfiguration<?, ?> producerConfiguration : this.producerConfigurations.values()) {
                producerConfiguration.stop();
            }
        }
    }

    public final void start() {
        if (this.running.compareAndSet(false, true)) {
            this.doStart();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getComponentType() + ":" + this.getComponentName() + " is already running"));
        }
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.doStop();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getComponentType() + ":" + this.getComponentName() + " is not running"));
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public Future<RecordMetadata> send(String topic, Object messageKey, Object messagePayload) {
        return this.send(topic, null, messageKey, messagePayload);
    }

    public Future<RecordMetadata> send(String topic, Integer partition, Object messageKey, Object messagePayload) {
        ProducerConfiguration<?, ?> producerConfiguration;
        if (!this.running.get()) {
            this.start();
        }
        ProducerConfiguration<?, ?> producerConfiguration2 = producerConfiguration = StringUtils.hasText((String)topic) ? this.getTopicConfiguration(topic) : null;
        if (producerConfiguration != null) {
            return producerConfiguration.convertAndSend(topic, partition, messageKey, messagePayload);
        }
        if (this.theProducerConfiguration != null) {
            return this.theProducerConfiguration.convertAndSend(topic, partition, messageKey, messagePayload);
        }
        throw new IllegalStateException("Could not send messages as there are multiple producer configurations with no topic information found from the message header.");
    }
}

