/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.concurrent.Future;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ProducerConfiguration<K, V> {
    private final Producer<K, V> producer;
    private final ProducerMetadata<K, V> producerMetadata;
    private ConversionService conversionService;

    public ProducerConfiguration(ProducerMetadata<K, V> producerMetadata, Producer<K, V> producer) {
        Assert.notNull(producerMetadata);
        Assert.notNull(producer);
        this.producerMetadata = producerMetadata;
        this.producer = producer;
        GenericConversionService genericConversionService = new GenericConversionService();
        genericConversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        this.conversionService = genericConversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"Conversion service must not be null");
        this.conversionService = conversionService;
    }

    public ProducerMetadata<K, V> getProducerMetadata() {
        return this.producerMetadata;
    }

    public Future<RecordMetadata> send(String topic, K messageKey, V messagePayload) {
        if (this.getProducerMetadata().getPartitioner() != null) {
            String targetTopic = StringUtils.hasText((String)topic) ? topic : this.producerMetadata.getTopic();
            int partition = this.getProducerMetadata().getPartitioner().partition(messageKey, this.producer.partitionsFor(targetTopic).size());
            return this.send(targetTopic, partition, messageKey, messagePayload);
        }
        return this.send(topic, null, messageKey, messagePayload);
    }

    public Future<RecordMetadata> send(String topic, Integer partition, K messageKey, V messagePayload) {
        String targetTopic = StringUtils.hasText((String)topic) ? topic : this.producerMetadata.getTopic();
        return this.producer.send(new ProducerRecord(targetTopic, partition, messageKey, messagePayload));
    }

    public Future<RecordMetadata> convertAndSend(String topic, Integer partition, Object messageKey, Object messagePayload) {
        return this.send(topic, partition, this.convertKeyIfNecessary(messageKey), this.convertPayloadIfNecessary(messagePayload));
    }

    public Future<RecordMetadata> convertAndSend(String topic, Object messageKey, Object messagePayload) {
        return this.send(topic, this.convertKeyIfNecessary(messageKey), this.convertPayloadIfNecessary(messagePayload));
    }

    private K convertKeyIfNecessary(Object messageKey) {
        if (messageKey != null) {
            if (this.getProducerMetadata().getKeyClassType().isAssignableFrom(messageKey.getClass())) {
                return this.getProducerMetadata().getKeyClassType().cast(messageKey);
            }
            return (K)this.conversionService.convert(messageKey, this.producerMetadata.getKeyClassType());
        }
        return null;
    }

    private V convertPayloadIfNecessary(Object messagePayload) {
        if (messagePayload != null) {
            if (this.getProducerMetadata().getKeyClassType().isAssignableFrom(messagePayload.getClass())) {
                return this.getProducerMetadata().getValueClassType().cast(messagePayload);
            }
            return (V)this.conversionService.convert(messagePayload, this.producerMetadata.getValueClassType());
        }
        return null;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return "ProducerConfiguration [producerMetadata=" + this.producerMetadata + "]";
    }

    public void stop() {
        this.producer.close();
    }
}

