/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationObservationContext;
import org.springframework.security.authorization.AuthorizationObservationConvention;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.core.Authentication;
import reactor.core.publisher.Mono;

public final class ObservationReactiveAuthorizationManager<T>
implements ReactiveAuthorizationManager<T> {
    private final ObservationRegistry registry;
    private final ReactiveAuthorizationManager<T> delegate;
    private final AuthorizationObservationConvention convention = new AuthorizationObservationConvention();

    public ObservationReactiveAuthorizationManager(ObservationRegistry registry, ReactiveAuthorizationManager<T> delegate) {
        this.registry = registry;
        this.delegate = delegate;
    }

    @Override
    public Mono<AuthorizationDecision> check(Mono<Authentication> authentication, T object) {
        AuthorizationObservationContext context = new AuthorizationObservationContext(object);
        Mono wrapped = authentication.map(auth -> {
            context.setAuthentication((Authentication)auth);
            return context.getAuthentication();
        });
        Observation observation = Observation.createNotStarted((ObservationConvention)this.convention, () -> context, (ObservationRegistry)this.registry).start();
        return this.delegate.check((Mono<Authentication>)wrapped, object).doOnSuccess(decision -> {
            context.setDecision((AuthorizationDecision)decision);
            if (decision == null || !decision.isGranted()) {
                observation.error((Throwable)new AccessDeniedException("Access Denied"));
            }
            observation.stop();
        }).doOnCancel(() -> ((Observation)observation).stop()).doOnError(t -> {
            observation.error(t);
            observation.stop();
        });
    }
}

