/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex.feature;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import org.graalvm.nativeimage.hosted.Feature;
import org.springframework.aot.nativex.feature.ThrowawayClassLoader;

class PreComputeFieldFeature
implements Feature {
    private static Pattern[] patterns = new Pattern[]{Pattern.compile(Pattern.quote("org.springframework.core.NativeDetector#imageCode")), Pattern.compile(Pattern.quote("org.springframework.") + ".*#.*Present"), Pattern.compile(Pattern.quote("org.springframework.") + ".*#.*PRESENT"), Pattern.compile(Pattern.quote("reactor.") + ".*#.*Available")};
    private final ThrowawayClassLoader throwawayClassLoader = new ThrowawayClassLoader(PreComputeFieldFeature.class.getClassLoader());

    PreComputeFieldFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerSubtypeReachabilityHandler(this::iterateFields, Object.class);
    }

    private void iterateFields(Feature.DuringAnalysisAccess access, Class<?> subtype) {
        try {
            for (Field field : subtype.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || field.isEnumConstant() || field.getType() != Boolean.TYPE && field.getType() != Boolean.class) continue;
                String fieldIdentifier = field.getDeclaringClass().getName() + "#" + field.getName();
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(fieldIdentifier).matches()) continue;
                    try {
                        Object fieldValue = this.provideFieldValue(field);
                        access.registerFieldValueTransformer(field, (receiver, originalValue) -> fieldValue);
                        System.out.println("Field " + fieldIdentifier + " set to " + fieldValue + " at build time");
                    }
                    catch (Throwable ex) {
                        System.out.println("Field " + fieldIdentifier + " will be evaluated at runtime due to this error during build time evaluation: " + ex.getMessage());
                    }
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private Object provideFieldValue(Field field) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> throwawayClass = this.throwawayClassLoader.loadClass(field.getDeclaringClass().getName());
        Field throwawayField = throwawayClass.getDeclaredField(field.getName());
        throwawayField.setAccessible(true);
        return throwawayField.get(null);
    }
}

