/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import org.assertj.core.api.AssertProvider;
import org.springframework.lang.Nullable;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.test.json.JsonContentAssert;
import org.springframework.util.Assert;

public final class JsonContent
implements AssertProvider<JsonContentAssert> {
    private final String json;
    @Nullable
    private final HttpMessageContentConverter contentConverter;

    public JsonContent(String json, @Nullable HttpMessageContentConverter contentConverter) {
        Assert.notNull((Object)json, (String)"JSON must not be null");
        this.json = json;
        this.contentConverter = contentConverter;
    }

    public JsonContent(String json) {
        this(json, null);
    }

    public JsonContentAssert assertThat() {
        return new JsonContentAssert(this);
    }

    public String getJson() {
        return this.json;
    }

    @Nullable
    HttpMessageContentConverter getContentConverter() {
        return this.contentConverter;
    }

    public String toString() {
        return "JsonContent " + this.json;
    }
}

