/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.github.dockerjava.api.model.BlkioRateDevice;
import com.github.dockerjava.api.model.BlkioWeightDevice;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.Isolation;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.Links;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HostConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<String> PREDEFINED_NETWORKS = Arrays.asList("bridge", "host", "none");
    @JsonProperty(value="Binds")
    private Binds binds;
    @JsonProperty(value="BlkioWeight")
    private Integer blkioWeight;
    @JsonProperty(value="BlkioWeightDevice")
    private List<BlkioWeightDevice> blkioWeightDevice;
    @JsonProperty(value="BlkioDeviceReadBps")
    private List<BlkioRateDevice> blkioDeviceReadBps;
    @JsonProperty(value="BlkioDeviceWriteBps")
    private List<BlkioRateDevice> blkioDeviceWriteBps;
    @JsonProperty(value="BlkioDeviceReadIOps")
    private List<BlkioRateDevice> blkioDeviceReadIOps;
    @JsonProperty(value="BlkioDeviceWriteIOps")
    private List<BlkioRateDevice> blkioDeviceWriteIOps;
    @JsonProperty(value="MemorySwappiness")
    private Long memorySwappiness;
    @JsonProperty(value="NanoCPUs")
    private Long nanoCPUs;
    @JsonProperty(value="CapAdd")
    private Capability[] capAdd;
    @JsonProperty(value="CapDrop")
    private Capability[] capDrop;
    @JsonProperty(value="ContainerIDFile")
    private String containerIDFile;
    @JsonProperty(value="CpuPeriod")
    private Long cpuPeriod;
    @JsonProperty(value="CpuRealtimePeriod")
    private Long cpuRealtimePeriod;
    @JsonProperty(value="CpuRealtimeRuntime")
    private Long cpuRealtimeRuntime;
    @JsonProperty(value="CpuShares")
    private Integer cpuShares;
    @JsonProperty(value="CpuQuota")
    private Long cpuQuota;
    @JsonProperty(value="CpusetCpus")
    private String cpusetCpus;
    @JsonProperty(value="CpusetMems")
    private String cpusetMems;
    @JsonProperty(value="Devices")
    private Device[] devices;
    @JsonProperty(value="DeviceCgroupRules")
    private List<String> deviceCgroupRules;
    @JsonProperty(value="DiskQuota")
    private Long diskQuota;
    @JsonProperty(value="Dns")
    private String[] dns;
    @JsonProperty(value="DnsOptions")
    private List<String> dnsOptions;
    @JsonProperty(value="DnsSearch")
    private String[] dnsSearch;
    @JsonProperty(value="ExtraHosts")
    private String[] extraHosts;
    @JsonProperty(value="GroupAdd")
    private List<String> groupAdd;
    @JsonProperty(value="IpcMode")
    private String ipcMode;
    @JsonProperty(value="Cgroup")
    private String cgroup;
    @JsonProperty(value="Links")
    private Links links;
    @JsonProperty(value="LogConfig")
    private LogConfig logConfig;
    @JsonProperty(value="LxcConf")
    private LxcConf[] lxcConf;
    @JsonProperty(value="Memory")
    private Long memory;
    @JsonProperty(value="MemorySwap")
    private Long memorySwap;
    @JsonProperty(value="MemoryReservation")
    private Long memoryReservation;
    @JsonProperty(value="KernelMemory")
    private Long kernelMemory;
    @JsonProperty(value="NetworkMode")
    private String networkMode;
    @JsonProperty(value="OomKillDisable")
    private Boolean oomKillDisable;
    @JsonProperty(value="Init")
    private Boolean init;
    @JsonProperty(value="AutoRemove")
    private Boolean autoRemove;
    @JsonProperty(value="OomScoreAdj")
    private Integer oomScoreAdj;
    @JsonProperty(value="PortBindings")
    private Ports portBindings;
    @JsonProperty(value="Privileged")
    private Boolean privileged;
    @JsonProperty(value="PublishAllPorts")
    private Boolean publishAllPorts;
    @JsonProperty(value="ReadonlyRootfs")
    private Boolean readonlyRootfs;
    @JsonProperty(value="RestartPolicy")
    private RestartPolicy restartPolicy;
    @JsonProperty(value="Ulimits")
    private Ulimit[] ulimits;
    @JsonProperty(value="CpuCount")
    private Long cpuCount;
    @JsonProperty(value="CpuPercent")
    private Long cpuPercent;
    @JsonProperty(value="IOMaximumIOps")
    private Long ioMaximumIOps;
    @JsonProperty(value="IOMaximumBandwidth")
    private Long ioMaximumBandwidth;
    @JsonProperty(value="VolumesFrom")
    private VolumesFrom[] volumesFrom;
    @JsonProperty(value="Mounts")
    private List<Mount> mounts;
    @JsonProperty(value="PidMode")
    private String pidMode;
    @JsonProperty(value="Isolation")
    private Isolation isolation;
    @JsonProperty(value="SecurityOpt")
    private List<String> securityOpts;
    @JsonProperty(value="StorageOpt")
    private Map<String, String> storageOpt;
    @JsonProperty(value="CgroupParent")
    private String cgroupParent;
    @JsonProperty(value="VolumeDriver")
    private String volumeDriver;
    @JsonProperty(value="ShmSize")
    private Long shmSize;
    @JsonProperty(value="PidsLimit")
    private Long pidsLimit;
    @JsonProperty(value="Runtime")
    private String runtime;
    @JsonProperty(value="Tmpfs")
    private Map<String, String> tmpFs;
    @JsonProperty(value="UTSMode")
    private String utSMode;
    @JsonProperty(value="UsernsMode")
    private String usernsMode;
    @JsonProperty(value="Sysctls")
    private Map<String, String> sysctls;
    @JsonProperty(value="ConsoleSize")
    private List<Integer> consoleSize;

    public static HostConfig newHostConfig() {
        return new HostConfig();
    }

    @JsonIgnore
    public Bind[] getBinds() {
        return this.binds == null ? new Bind[]{} : this.binds.getBinds();
    }

    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    public Capability[] getCapAdd() {
        return this.capAdd;
    }

    public Capability[] getCapDrop() {
        return this.capDrop;
    }

    public String getContainerIDFile() {
        return this.containerIDFile;
    }

    public Long getCpuPeriod() {
        return this.cpuPeriod;
    }

    public Integer getCpuShares() {
        return this.cpuShares;
    }

    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    public String getCpusetMems() {
        return this.cpusetMems;
    }

    public Device[] getDevices() {
        return this.devices;
    }

    public Long getDiskQuota() {
        return this.diskQuota;
    }

    public String[] getDns() {
        return this.dns;
    }

    public String[] getDnsSearch() {
        return this.dnsSearch;
    }

    public String[] getExtraHosts() {
        return this.extraHosts;
    }

    @JsonIgnore
    public Link[] getLinks() {
        return this.links == null ? new Link[]{} : this.links.getLinks();
    }

    @JsonIgnore
    public LogConfig getLogConfig() {
        return this.logConfig == null ? new LogConfig() : this.logConfig;
    }

    public LxcConf[] getLxcConf() {
        return this.lxcConf;
    }

    public Long getMemory() {
        return this.memory;
    }

    public Long getMemorySwap() {
        return this.memorySwap;
    }

    public String getNetworkMode() {
        return this.networkMode;
    }

    public Ports getPortBindings() {
        return this.portBindings;
    }

    public RestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public Ulimit[] getUlimits() {
        return this.ulimits;
    }

    public VolumesFrom[] getVolumesFrom() {
        return this.volumesFrom;
    }

    @CheckForNull
    public String getPidMode() {
        return this.pidMode;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    @CheckForNull
    public List<BlkioRateDevice> getBlkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    @CheckForNull
    public List<BlkioWeightDevice> getBlkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    @CheckForNull
    public Integer getOomScoreAdj() {
        return this.oomScoreAdj;
    }

    @CheckForNull
    public Long getCpuQuota() {
        return this.cpuQuota;
    }

    @CheckForNull
    public Long getKernelMemory() {
        return this.kernelMemory;
    }

    @CheckForNull
    public Long getMemoryReservation() {
        return this.memoryReservation;
    }

    @CheckForNull
    public Long getMemorySwappiness() {
        return this.memorySwappiness;
    }

    @CheckForNull
    public Boolean getOomKillDisable() {
        return this.oomKillDisable;
    }

    @CheckForNull
    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    @CheckForNull
    public List<String> getSecurityOpts() {
        return this.securityOpts;
    }

    @CheckForNull
    public String getCgroupParent() {
        return this.cgroupParent;
    }

    @CheckForNull
    public Long getShmSize() {
        return this.shmSize;
    }

    @CheckForNull
    public String getVolumeDriver() {
        return this.volumeDriver;
    }

    @CheckForNull
    public Long getPidsLimit() {
        return this.pidsLimit;
    }

    @CheckForNull
    public Map<String, String> getTmpFs() {
        return this.tmpFs;
    }

    @JsonIgnore
    public boolean isUserDefinedNetwork() {
        return this.networkMode != null && !PREDEFINED_NETWORKS.contains(this.networkMode) && !this.networkMode.startsWith("container:");
    }

    public String getRuntime() {
        return this.runtime;
    }

    @JsonIgnore
    public void setBinds(Bind ... binds) {
        this.binds = new Binds(binds);
    }

    @JsonIgnore
    public void setLinks(Link ... links) {
        this.links = new Links(links);
    }

    public HostConfig withBinds(Binds binds) {
        this.binds = binds;
        return this;
    }

    public HostConfig withBinds(Bind ... binds) {
        Preconditions.checkNotNull(binds, "binds was not specified");
        this.setBinds(binds);
        return this;
    }

    public HostConfig withBinds(List<Bind> binds) {
        Preconditions.checkNotNull(binds, "binds was not specified");
        return this.withBinds(binds.toArray(new Bind[binds.size()]));
    }

    public HostConfig withBlkioDeviceReadBps(List<BlkioRateDevice> blkioDeviceReadBps) {
        this.blkioDeviceReadBps = blkioDeviceReadBps;
        return this;
    }

    public HostConfig withBlkioDeviceReadIOps(List<BlkioRateDevice> blkioDeviceReadIOps) {
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
        return this;
    }

    public HostConfig withBlkioDeviceWriteBps(List<BlkioRateDevice> blkioDeviceWriteBps) {
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
        return this;
    }

    public HostConfig withBlkioDeviceWriteIOps(List<BlkioRateDevice> blkioDeviceWriteIOps) {
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
        return this;
    }

    public HostConfig withBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return this;
    }

    public HostConfig withBlkioWeightDevice(List<BlkioWeightDevice> blkioWeightDevice) {
        this.blkioWeightDevice = blkioWeightDevice;
        return this;
    }

    public HostConfig withCapAdd(Capability ... capAdd) {
        this.capAdd = capAdd;
        return this;
    }

    public HostConfig withCapDrop(Capability ... capDrop) {
        this.capDrop = capDrop;
        return this;
    }

    public HostConfig withCgroupParent(String cgroupParent) {
        this.cgroupParent = cgroupParent;
        return this;
    }

    public HostConfig withContainerIDFile(String containerIDFile) {
        this.containerIDFile = containerIDFile;
        return this;
    }

    public HostConfig withCpuPeriod(Long cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return this;
    }

    public HostConfig withCpuQuota(Long cpuQuota) {
        this.cpuQuota = cpuQuota;
        return this;
    }

    public HostConfig withCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return this;
    }

    public HostConfig withCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return this;
    }

    public HostConfig withCpuShares(Integer cpuShares) {
        this.cpuShares = cpuShares;
        return this;
    }

    public HostConfig withDevices(Device ... devices) {
        this.devices = devices;
        return this;
    }

    public HostConfig withDevices(List<Device> devices) {
        Preconditions.checkNotNull(devices, "devices was not specified");
        return this.withDevices(devices.toArray(new Device[0]));
    }

    public HostConfig withDiskQuota(Long diskQuota) {
        this.diskQuota = diskQuota;
        return this;
    }

    public HostConfig withDns(String ... dns) {
        this.dns = dns;
        return this;
    }

    public HostConfig withDns(List<String> dns) {
        Preconditions.checkNotNull(dns, "dns was not specified");
        return this.withDns(dns.toArray(new String[0]));
    }

    public HostConfig withDnsSearch(String ... dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public HostConfig withDnsSearch(List<String> dnsSearch) {
        Preconditions.checkNotNull(dnsSearch, "dnsSearch was not specified");
        return this.withDnsSearch(dnsSearch.toArray(new String[0]));
    }

    public HostConfig withExtraHosts(String ... extraHosts) {
        this.extraHosts = extraHosts;
        return this;
    }

    public HostConfig withKernelMemory(Long kernelMemory) {
        this.kernelMemory = kernelMemory;
        return this;
    }

    public HostConfig withLinks(Links links) {
        this.links = links;
        return this;
    }

    public HostConfig withLinks(Link ... links) {
        Preconditions.checkNotNull(links, "links was not specified");
        this.setLinks(links);
        return this;
    }

    public HostConfig withLinks(List<Link> links) {
        Preconditions.checkNotNull(links, "links was not specified");
        return this.withLinks(links.toArray(new Link[0]));
    }

    public HostConfig withLogConfig(LogConfig logConfig) {
        this.logConfig = logConfig;
        return this;
    }

    public HostConfig withLxcConf(LxcConf[] lxcConf) {
        this.lxcConf = lxcConf;
        return this;
    }

    public HostConfig withMemory(Long memory) {
        this.memory = memory;
        return this;
    }

    public HostConfig withMemoryReservation(Long memoryReservation) {
        this.memoryReservation = memoryReservation;
        return this;
    }

    public HostConfig withMemorySwap(Long memorySwap) {
        this.memorySwap = memorySwap;
        return this;
    }

    public HostConfig withMemorySwappiness(Long memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
        return this;
    }

    public HostConfig withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return this;
    }

    public HostConfig withOomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
        return this;
    }

    public HostConfig withAutoRemove(Boolean autoRemove) {
        this.autoRemove = autoRemove;
        return this;
    }

    public HostConfig withOomScoreAdj(Integer oomScoreAdj) {
        this.oomScoreAdj = oomScoreAdj;
        return this;
    }

    public HostConfig withPidMode(String pidMode) {
        this.pidMode = pidMode;
        return this;
    }

    public HostConfig withPortBindings(Ports portBindings) {
        this.portBindings = portBindings;
        return this;
    }

    public HostConfig withPortBindings(PortBinding ... portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        this.withPortBindings(new Ports(portBindings));
        return this;
    }

    public HostConfig withPortBindings(List<PortBinding> portBindings) {
        Preconditions.checkNotNull(portBindings, "portBindings was not specified");
        return this.withPortBindings(portBindings.toArray(new PortBinding[0]));
    }

    @CheckForNull
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public HostConfig withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @CheckForNull
    public Boolean getPublishAllPorts() {
        return this.publishAllPorts;
    }

    public HostConfig withPublishAllPorts(Boolean publishAllPorts) {
        this.publishAllPorts = publishAllPorts;
        return this;
    }

    @CheckForNull
    public Boolean getReadonlyRootfs() {
        return this.readonlyRootfs;
    }

    public HostConfig withReadonlyRootfs(Boolean readonlyRootfs) {
        this.readonlyRootfs = readonlyRootfs;
        return this;
    }

    public HostConfig withRestartPolicy(RestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public HostConfig withSecurityOpts(List<String> securityOpts) {
        this.securityOpts = securityOpts;
        return this;
    }

    public HostConfig withShmSize(Long shmSize) {
        this.shmSize = shmSize;
        return this;
    }

    public HostConfig withUlimits(Ulimit[] ulimits) {
        this.ulimits = ulimits;
        return this;
    }

    public HostConfig withUlimits(List<Ulimit> ulimits) {
        Preconditions.checkNotNull(ulimits, "no ulimits was specified");
        return this.withUlimits(ulimits.toArray(new Ulimit[0]));
    }

    public HostConfig withVolumeDriver(String volumeDriver) {
        this.volumeDriver = volumeDriver;
        return this;
    }

    public HostConfig withVolumesFrom(VolumesFrom ... volumesFrom) {
        this.volumesFrom = volumesFrom;
        return this;
    }

    public HostConfig withVolumesFrom(List<VolumesFrom> volumesFrom) {
        Preconditions.checkNotNull(volumesFrom, "volumesFrom was not specified");
        return this.withVolumesFrom(volumesFrom.toArray(new VolumesFrom[0]));
    }

    public HostConfig withPidsLimit(Long pidsLimit) {
        this.pidsLimit = pidsLimit;
        return this;
    }

    public HostConfig withRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    public HostConfig withTmpFs(Map<String, String> tmpFs) {
        this.tmpFs = tmpFs;
        return this;
    }

    @CheckForNull
    public List<String> getDeviceCgroupRules() {
        return this.deviceCgroupRules;
    }

    public HostConfig withDeviceCgroupRules(List<String> deviceCgroupRules) {
        this.deviceCgroupRules = deviceCgroupRules;
        return this;
    }

    @CheckForNull
    public Long getNanoCPUs() {
        return this.nanoCPUs;
    }

    public HostConfig withNanoCPUs(Long nanoCPUs) {
        this.nanoCPUs = nanoCPUs;
        return this;
    }

    @CheckForNull
    public Boolean getInit() {
        return this.init;
    }

    public HostConfig withInit(Boolean init) {
        this.init = init;
        return this;
    }

    @CheckForNull
    public Long getCpuCount() {
        return this.cpuCount;
    }

    public HostConfig withCpuCount(Long cpuCount) {
        this.cpuCount = cpuCount;
        return this;
    }

    @CheckForNull
    public Long getCpuPercent() {
        return this.cpuPercent;
    }

    public HostConfig withCpuPercent(Long cpuPercent) {
        this.cpuPercent = cpuPercent;
        return this;
    }

    @CheckForNull
    public Long getIoMaximumIOps() {
        return this.ioMaximumIOps;
    }

    public HostConfig withIoMaximumIOps(Long ioMaximumIOps) {
        this.ioMaximumIOps = ioMaximumIOps;
        return this;
    }

    @CheckForNull
    public Long getIoMaximumBandwidth() {
        return this.ioMaximumBandwidth;
    }

    public HostConfig withIoMaximumBandwidth(Long ioMaximumBandwidth) {
        this.ioMaximumBandwidth = ioMaximumBandwidth;
        return this;
    }

    @CheckForNull
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public HostConfig withMounts(List<Mount> mounts) {
        this.mounts = mounts;
        return this;
    }

    @CheckForNull
    public List<String> getDnsOptions() {
        return this.dnsOptions;
    }

    public HostConfig withDnsOptions(List<String> dnsOptions) {
        this.dnsOptions = dnsOptions;
        return this;
    }

    @CheckForNull
    public List<String> getGroupAdd() {
        return this.groupAdd;
    }

    public HostConfig withGroupAdd(List<String> groupAdd) {
        this.groupAdd = groupAdd;
        return this;
    }

    @CheckForNull
    public String getIpcMode() {
        return this.ipcMode;
    }

    public HostConfig withIpcMode(String ipcMode) {
        this.ipcMode = ipcMode;
        return this;
    }

    @CheckForNull
    public String getCgroup() {
        return this.cgroup;
    }

    public HostConfig withCgroup(String cgroup) {
        this.cgroup = cgroup;
        return this;
    }

    @CheckForNull
    public Map<String, String> getStorageOpt() {
        return this.storageOpt;
    }

    public HostConfig withStorageOpt(Map<String, String> storageOpt) {
        this.storageOpt = storageOpt;
        return this;
    }

    @CheckForNull
    public String getUtSMode() {
        return this.utSMode;
    }

    public HostConfig withUtSMode(String utSMode) {
        this.utSMode = utSMode;
        return this;
    }

    @CheckForNull
    public String getUsernsMode() {
        return this.usernsMode;
    }

    public HostConfig withUsernsMode(String usernsMode) {
        this.usernsMode = usernsMode;
        return this;
    }

    @CheckForNull
    public Map<String, String> getSysctls() {
        return this.sysctls;
    }

    public HostConfig withSysctls(Map<String, String> sysctls) {
        this.sysctls = sysctls;
        return this;
    }

    @CheckForNull
    public List<Integer> getConsoleSize() {
        return this.consoleSize;
    }

    public HostConfig withConsoleSize(List<Integer> consoleSize) {
        this.consoleSize = consoleSize;
        return this;
    }

    @CheckForNull
    public Isolation getIsolation() {
        return this.isolation;
    }

    public HostConfig withIsolation(Isolation isolation) {
        this.isolation = isolation;
        return this;
    }

    @CheckForNull
    public Long getCpuRealtimePeriod() {
        return this.cpuRealtimePeriod;
    }

    public HostConfig withCpuRealtimePeriod(Long cpuRealtimePeriod) {
        this.cpuRealtimePeriod = cpuRealtimePeriod;
        return this;
    }

    @CheckForNull
    public Long getCpuRealtimeRuntime() {
        return this.cpuRealtimeRuntime;
    }

    public HostConfig withCpuRealtimeRuntime(Long cpuRealtimeRuntime) {
        this.cpuRealtimeRuntime = cpuRealtimeRuntime;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

