/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonValue;

public class LogConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Type")
    public LoggingType type = null;
    @JsonProperty(value="Config")
    public Map<String, String> config;

    public LogConfig(LoggingType type, Map<String, String> config) {
        this.type = type;
        this.config = config;
    }

    public LogConfig(LoggingType type) {
        this(type, null);
    }

    public LogConfig() {
    }

    public LoggingType getType() {
        return this.type;
    }

    public LogConfig setType(LoggingType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public Map<String, String> getConfig() {
        return this.config;
    }

    @JsonIgnore
    public LogConfig setConfig(Map<String, String> config) {
        this.config = config;
        return this;
    }

    public static enum LoggingType {
        NONE("none"),
        DEFAULT("json-file"),
        ETWLOGS("etwlogs"),
        JSON_FILE("json-file"),
        SYSLOG("syslog"),
        JOURNALD("journald"),
        GELF("gelf"),
        FLUENTD("fluentd"),
        AWSLOGS("awslogs"),
        DB("db"),
        SPLUNK("splunk"),
        GCPLOGS("gcplogs");

        private String type;

        private LoggingType(String type) {
            this.type = type;
        }

        @JsonValue
        public String getType() {
            return this.type;
        }

        @JsonCreator
        @CheckForNull
        public static LoggingType fromValue(String text) {
            for (LoggingType b : LoggingType.values()) {
                if (!String.valueOf(b.type).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.type);
        }
    }
}

