/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.BindOptions;
import com.github.dockerjava.api.model.MountType;
import com.github.dockerjava.api.model.TmpfsOptions;
import com.github.dockerjava.api.model.VolumeOptions;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringStyle;

public class Mount
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="Type")
    private MountType type;
    @JsonProperty(value="Source")
    private String source;
    @JsonProperty(value="Target")
    private String target;
    @JsonProperty(value="ReadOnly")
    private Boolean readOnly;
    @JsonProperty(value="BindOptions")
    private BindOptions bindOptions;
    @JsonProperty(value="VolumeOptions")
    private VolumeOptions volumeOptions;
    @JsonProperty(value="TmpfsOptions")
    private TmpfsOptions tmpfsOptions;

    @CheckForNull
    public MountType getType() {
        return this.type;
    }

    public Mount withType(MountType type) {
        this.type = type;
        return this;
    }

    @CheckForNull
    public String getSource() {
        return this.source;
    }

    public Mount withSource(String source) {
        this.source = source;
        return this;
    }

    @CheckForNull
    public String getTarget() {
        return this.target;
    }

    public Mount withTarget(String target) {
        this.target = target;
        return this;
    }

    @CheckForNull
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Mount withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @CheckForNull
    public BindOptions getBindOptions() {
        return this.bindOptions;
    }

    public Mount withBindOptions(BindOptions bindOptions) {
        this.bindOptions = bindOptions;
        if (bindOptions != null) {
            this.type = MountType.BIND;
        }
        return this;
    }

    @CheckForNull
    public VolumeOptions getVolumeOptions() {
        return this.volumeOptions;
    }

    public Mount withVolumeOptions(VolumeOptions volumeOptions) {
        this.volumeOptions = volumeOptions;
        if (volumeOptions != null) {
            this.type = MountType.VOLUME;
        }
        return this;
    }

    @CheckForNull
    public TmpfsOptions getTmpfsOptions() {
        return this.tmpfsOptions;
    }

    public Mount withTmpfsOptions(TmpfsOptions tmpfsOptions) {
        this.tmpfsOptions = tmpfsOptions;
        if (tmpfsOptions != null) {
            this.type = MountType.TMPFS;
        }
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

