/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.github.dockerjava.api.model.ContainerSpec;
import com.github.dockerjava.api.model.Driver;
import com.github.dockerjava.api.model.NetworkAttachmentConfig;
import com.github.dockerjava.api.model.ResourceRequirements;
import com.github.dockerjava.api.model.ServicePlacement;
import com.github.dockerjava.api.model.ServiceRestartPolicy;
import java.io.Serializable;
import java.util.List;
import javax.annotation.CheckForNull;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.testcontainers.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.testcontainers.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.HashCodeBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TaskSpec
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="ContainerSpec")
    private ContainerSpec containerSpec;
    @JsonProperty(value="Resources")
    private ResourceRequirements resources;
    @JsonProperty(value="RestartPolicy")
    private ServiceRestartPolicy restartPolicy;
    @JsonProperty(value="Placement")
    private ServicePlacement placement;
    @JsonProperty(value="LogDriver")
    private Driver logDriver;
    @JsonProperty(value="ForceUpdate")
    private Integer forceUpdate;
    @JsonProperty(value="Networks")
    private List<NetworkAttachmentConfig> networks;
    @JsonProperty(value="Runtime")
    private String runtime;

    @CheckForNull
    public ContainerSpec getContainerSpec() {
        return this.containerSpec;
    }

    public TaskSpec withContainerSpec(ContainerSpec containerSpec) {
        this.containerSpec = containerSpec;
        return this;
    }

    @CheckForNull
    public ResourceRequirements getResources() {
        return this.resources;
    }

    public TaskSpec withResources(ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @CheckForNull
    public ServiceRestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public TaskSpec withRestartPolicy(ServiceRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @CheckForNull
    public ServicePlacement getPlacement() {
        return this.placement;
    }

    public TaskSpec withPlacement(ServicePlacement placement) {
        this.placement = placement;
        return this;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public TaskSpec withRuntime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    @CheckForNull
    public Driver getLogDriver() {
        return this.logDriver;
    }

    public TaskSpec withLogDriver(Driver logDriver) {
        this.logDriver = logDriver;
        return this;
    }

    @CheckForNull
    public Integer getForceUpdate() {
        return this.forceUpdate;
    }

    public TaskSpec withForceUpdate(Integer forceUpdate) {
        this.forceUpdate = forceUpdate;
        return this;
    }

    public List<NetworkAttachmentConfig> getNetworks() {
        return this.networks;
    }

    public TaskSpec withNetworks(List<NetworkAttachmentConfig> networks) {
        this.networks = networks;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals(this, o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
}

