/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.exception.InvalidRepositoryNameException;
import java.util.regex.Pattern;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang.builder.EqualsBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringBuilder;
import org.testcontainers.shaded.org.apache.commons.lang.builder.ToStringStyle;

public class NameParser {
    private static final int RepositoryNameTotalLengthMax = 255;
    private static final String SHA256_SEPARATOR = "@sha256:";
    private static final Pattern RepositoryNameComponentRegexp = Pattern.compile("[a-z0-9]+(?:[._-][a-z0-9]+)*");
    private static final Pattern RepositoryNameComponentAnchoredRegexp = Pattern.compile("^" + RepositoryNameComponentRegexp.pattern() + "$");

    private NameParser() {
    }

    public static ReposTag parseRepositoryTag(String name) {
        int n = name.lastIndexOf(58);
        if (n < 0) {
            return new ReposTag(name, "");
        }
        String tag = name.substring(n + 1);
        if (StringUtils.containsIgnoreCase(name, SHA256_SEPARATOR)) {
            return new ReposTag(name, "");
        }
        if (!tag.contains("/")) {
            return new ReposTag(name.substring(0, n), tag);
        }
        return new ReposTag(name, "");
    }

    public static void validateRepoName(String name) {
        String[] components;
        if (name.isEmpty()) {
            throw new InvalidRepositoryNameException(String.format("Invalid empty repository name \"%s\"", name));
        }
        if (name.length() > 255) {
            throw new InvalidRepositoryNameException(String.format("Repository name \"%s\" is longer than 255", name));
        }
        for (String component : components = name.split("/")) {
            if (RepositoryNameComponentAnchoredRegexp.matcher(component).matches()) continue;
            throw new InvalidRepositoryNameException(String.format("Repository name \"%s\" is invalid. Component: %s", name, component));
        }
    }

    public static HostnameReposName resolveRepositoryName(String reposName) {
        if (reposName.contains("://")) {
            throw new InvalidRepositoryNameException("RepositoryName shouldn't contain a scheme");
        }
        String[] nameParts = reposName.split("/", 2);
        if (nameParts.length == 1 || !nameParts[0].contains(".") && !nameParts[0].contains(":") && !nameParts[0].equals("localhost")) {
            return new HostnameReposName("https://index.docker.io/v1/", reposName);
        }
        String hostname = nameParts[0];
        reposName = nameParts[1];
        if (hostname.contains("index.docker.io")) {
            throw new InvalidRepositoryNameException(String.format("Invalid repository name, try \"%s\" instead", reposName));
        }
        if (StringUtils.containsIgnoreCase(reposName, SHA256_SEPARATOR)) {
            reposName = StringUtils.substringBeforeLast(reposName, SHA256_SEPARATOR);
        }
        NameParser.validateRepoName(reposName);
        return new HostnameReposName(hostname, reposName);
    }

    public static class HostnameReposName {
        public final String hostname;
        public final String reposName;

        public HostnameReposName(String hostname, String reposName) {
            this.hostname = hostname;
            this.reposName = reposName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HostnameReposName) {
                HostnameReposName other = (HostnameReposName)obj;
                return new EqualsBuilder().append(this.hostname, other.hostname).append(this.reposName, other.reposName).isEquals();
            }
            return false;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SIMPLE_STYLE);
        }
    }

    public static class ReposTag {
        public final String repos;
        public final String tag;

        public ReposTag(String repos, String tag) {
            this.repos = repos;
            this.tag = tag;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ReposTag) {
                ReposTag other = (ReposTag)obj;
                return new EqualsBuilder().append(this.repos, other.repos).append(this.tag, other.tag).isEquals();
            }
            return false;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.SIMPLE_STYLE);
        }
    }
}

