/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs.filter;

import com.github.dockerjava.api.exception.BadRequestException;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotAcceptableException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.exception.UnauthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class ResponseStatusExceptionFilter
implements ClientResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseStatusExceptionFilter.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        int status = responseContext.getStatus();
        switch (status) {
            case 200: 
            case 201: 
            case 204: {
                return;
            }
            case 304: {
                throw new NotModifiedException(this.getBodyAsMessage(responseContext));
            }
            case 400: {
                throw new BadRequestException(this.getBodyAsMessage(responseContext));
            }
            case 401: {
                throw new UnauthorizedException(this.getBodyAsMessage(responseContext));
            }
            case 404: {
                throw new NotFoundException(this.getBodyAsMessage(responseContext));
            }
            case 406: {
                throw new NotAcceptableException(this.getBodyAsMessage(responseContext));
            }
            case 409: {
                throw new ConflictException(this.getBodyAsMessage(responseContext));
            }
            case 500: {
                throw new InternalServerErrorException(this.getBodyAsMessage(responseContext));
            }
        }
        throw new DockerException(this.getBodyAsMessage(responseContext), status);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBodyAsMessage(ClientResponseContext responseContext) {
        if (!responseContext.hasEntity()) return null;
        try (InputStream entityStream = responseContext.getEntityStream();){
            String charsetName;
            Charset charset = null;
            MediaType mediaType = responseContext.getMediaType();
            if (mediaType != null && (charsetName = (String)mediaType.getParameters().get("charset")) != null) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            String message = IOUtils.toString(entityStream, charset);
            if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
                try {
                    JsonNode messageNode;
                    JsonNode node = new ObjectMapper().readTree(message);
                    if (node != null && (messageNode = node.get("message")) != null && messageNode.isTextual()) {
                        message = messageNode.textValue();
                    }
                }
                catch (IOException e) {
                    LOG.debug("Failed to unwrap error message: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            String string = message;
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

