/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.utility.LogUtils;

public interface ContainerState {
    public static final String STATE_HEALTHY = "healthy";

    default public String getContainerIpAddress() {
        return DockerClientFactory.instance().dockerHostIpAddress();
    }

    default public boolean isRunning() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            Boolean running = this.getCurrentContainerInfo().getState().getRunning();
            return Boolean.TRUE.equals(running);
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public boolean isCreated() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            String status = this.getCurrentContainerInfo().getState().getStatus();
            return "created".equalsIgnoreCase(status) || this.isRunning();
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public boolean isHealthy() {
        if (this.getContainerId() == null) {
            return false;
        }
        try {
            InspectContainerResponse inspectContainerResponse = this.getCurrentContainerInfo();
            String healthStatus = inspectContainerResponse.getState().getHealth().getStatus();
            return healthStatus.equals(STATE_HEALTHY);
        }
        catch (DockerException e) {
            return false;
        }
    }

    default public InspectContainerResponse getCurrentContainerInfo() {
        return DockerClientFactory.instance().client().inspectContainerCmd(this.getContainerId()).exec();
    }

    default public Integer getFirstMappedPort() {
        return this.getExposedPorts().stream().findFirst().map(this::getMappedPort).orElseThrow(() -> new IllegalStateException("Container doesn't expose any ports"));
    }

    default public Integer getMappedPort(int originalPort) {
        Preconditions.checkState(this.getContainerId() != null, "Mapped port can only be obtained after the container is started");
        Ports.Binding[] binding = new Ports.Binding[]{};
        InspectContainerResponse containerInfo = this.getContainerInfo();
        if (containerInfo != null) {
            binding = containerInfo.getNetworkSettings().getPorts().getBindings().get(new ExposedPort(originalPort));
        }
        if (binding != null && binding.length > 0 && binding[0] != null) {
            return Integer.valueOf(binding[0].getHostPortSpec());
        }
        throw new IllegalArgumentException("Requested port (" + originalPort + ") is not mapped");
    }

    public List<Integer> getExposedPorts();

    default public List<String> getPortBindings() {
        ArrayList<String> portBindings = new ArrayList<String>();
        Ports hostPortBindings = this.getContainerInfo().getHostConfig().getPortBindings();
        for (Map.Entry<ExposedPort, Ports.Binding[]> binding : hostPortBindings.getBindings().entrySet()) {
            for (Ports.Binding portBinding : binding.getValue()) {
                portBindings.add(String.format("%s:%s", portBinding.toString(), binding.getKey()));
            }
        }
        return portBindings;
    }

    default public List<Integer> getBoundPortNumbers() {
        return this.getPortBindings().stream().map(PortBinding::parse).map(PortBinding::getBinding).map(Ports.Binding::getHostPortSpec).filter(Objects::nonNull).map(Integer::valueOf).collect(Collectors.toList());
    }

    default public String getLogs() {
        return LogUtils.getOutput(DockerClientFactory.instance().client(), this.getContainerId(), new OutputFrame.OutputType[0]);
    }

    default public String getLogs(OutputFrame.OutputType ... types) {
        return LogUtils.getOutput(DockerClientFactory.instance().client(), this.getContainerId(), types);
    }

    public String getContainerId();

    public InspectContainerResponse getContainerInfo();
}

