/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.IndefiniteWaitOneShotStartupCheckStrategy;
import org.testcontainers.shaded.com.google.common.base.Joiner;
import org.testcontainers.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.shaded.org.apache.commons.lang.SystemUtils;
import org.testcontainers.utility.AuditLogger;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.TestcontainersConfiguration;

class ContainerisedDockerCompose
extends GenericContainer<ContainerisedDockerCompose>
implements DockerCompose {
    private static final String DOCKER_SOCKET_PATH = "/var/run/docker.sock";
    private static final String DOCKER_CONFIG_FILE = "/root/.docker/config.json";
    private static final String DOCKER_CONFIG_ENV = "DOCKER_CONFIG_FILE";
    private static final String DOCKER_CONFIG_PROPERTY = "dockerConfigFile";
    public static final char UNIX_PATH_SEPERATOR = ':';

    public ContainerisedDockerCompose(List<File> composeFiles, String identifier) {
        super(TestcontainersConfiguration.getInstance().getDockerComposeContainerImage());
        this.addEnv("COMPOSE_PROJECT_NAME", identifier);
        File dockerComposeBaseFile = composeFiles.get(0);
        String pwd = dockerComposeBaseFile.getAbsoluteFile().getParentFile().getAbsolutePath();
        String containerPwd = MountableFile.forHostPath(pwd).getFilesystemPath();
        List absoluteDockerComposeFiles = composeFiles.stream().map(File::getAbsolutePath).map(MountableFile::forHostPath).map(MountableFile::getFilesystemPath).collect(Collectors.toList());
        String composeFileEnvVariableValue = Joiner.on(':').join(absoluteDockerComposeFiles);
        this.logger().debug("Set env COMPOSE_FILE={}", (Object)composeFileEnvVariableValue);
        this.addEnv("COMPOSE_FILE", composeFileEnvVariableValue);
        this.addFileSystemBind(pwd, containerPwd, BindMode.READ_ONLY);
        this.addFileSystemBind(this.getDockerSocketHostPath(), "/docker.sock", BindMode.READ_WRITE);
        this.addEnv("DOCKER_HOST", "unix:///docker.sock");
        this.setStartupCheckStrategy(new IndefiniteWaitOneShotStartupCheckStrategy());
        this.setWorkingDirectory(containerPwd);
        String dockerConfigPath = this.determineDockerConfigPath();
        if (dockerConfigPath != null && !dockerConfigPath.isEmpty()) {
            this.addFileSystemBind(dockerConfigPath, DOCKER_CONFIG_FILE, BindMode.READ_ONLY);
        }
    }

    private String determineDockerConfigPath() {
        String dockerConfigEnv = System.getenv(DOCKER_CONFIG_ENV);
        String dockerConfigProperty = System.getProperty(DOCKER_CONFIG_PROPERTY);
        Path dockerConfig = Paths.get(System.getProperty("user.home"), ".docker", "config.json");
        if (dockerConfigEnv != null && !dockerConfigEnv.trim().isEmpty() && Files.exists(Paths.get(dockerConfigEnv, new String[0]), new LinkOption[0])) {
            return dockerConfigEnv;
        }
        if (dockerConfigProperty != null && !dockerConfigProperty.trim().isEmpty() && Files.exists(Paths.get(dockerConfigProperty, new String[0]), new LinkOption[0])) {
            return dockerConfigProperty;
        }
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            return dockerConfig.toString();
        }
        return null;
    }

    private String getDockerSocketHostPath() {
        return SystemUtils.IS_OS_WINDOWS ? "//var/run/docker.sock" : DOCKER_SOCKET_PATH;
    }

    @Override
    public void invoke() {
        super.start();
        this.followOutput(new Slf4jLogConsumer(this.logger()));
        this.logger().info("Docker Compose container is running for command: {}", (Object)Joiner.on(" ").join(this.getCommandParts()));
        while (this.isRunning()) {
            this.logger().trace("Compose container is still running");
            Uninterruptibles.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
        }
        this.logger().info("Docker Compose has finished running");
        AuditLogger.doComposeLog(this.getCommandParts(), this.getEnv());
        Integer exitCode = this.dockerClient.inspectContainerCmd(this.getContainerId()).exec().getState().getExitCode();
        if (exitCode == null || exitCode != 0) {
            throw new ContainerLaunchException("Containerised Docker Compose exited abnormally with code " + exitCode + " whilst running command: " + StringUtils.join((Object[])this.getCommandParts(), ' '));
        }
    }
}

