/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.rnorth.visibleassertions.VisibleAssertions;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ExecInContainerPattern;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.InternetProtocol;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PortForwardingContainer;
import org.testcontainers.containers.SelinuxContext;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.startupcheck.IsRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.MinimumDurationRunningStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.containers.wait.Wait;
import org.testcontainers.containers.wait.WaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;
import org.testcontainers.lifecycle.TestDescription;
import org.testcontainers.lifecycle.TestLifecycleAware;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.shaded.com.google.common.collect.Lists;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.CommandLine;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.DockerMachineClient;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.PathUtils;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestcontainersConfiguration;
import org.testcontainers.utility.ThrowingFunction;

public class GenericContainer<SELF extends GenericContainer<SELF>>
extends FailureDetectingExternalResource
implements Container<SELF>,
AutoCloseable,
WaitStrategyTarget,
Startable {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int CONTAINER_RUNNING_TIMEOUT_SEC = 30;
    public static final String INTERNAL_HOST_HOSTNAME = "host.testcontainers.internal";
    @NonNull
    private List<Integer> exposedPorts = new ArrayList<Integer>();
    @NonNull
    private List<String> portBindings = new ArrayList<String>();
    @NonNull
    private List<String> extraHosts = new ArrayList<String>();
    @NonNull
    private String networkMode;
    @NonNull
    private Network network;
    @NonNull
    private List<String> networkAliases = new ArrayList<String>(Arrays.asList("tc-" + Base58.randomString(8)));
    @NonNull
    private Future<String> image;
    @NonNull
    private Map<String, String> env = new HashMap<String, String>();
    @NonNull
    private Map<String, String> labels = new HashMap<String, String>();
    @NonNull
    private String[] commandParts = new String[0];
    @NonNull
    private List<Bind> binds = new ArrayList<Bind>();
    private boolean privilegedMode;
    @NonNull
    private List<VolumesFrom> volumesFroms = new ArrayList<VolumesFrom>();
    @Deprecated
    @NonNull
    private Map<String, LinkableContainer> linkedContainers = new HashMap<String, LinkableContainer>();
    private StartupCheckStrategy startupCheckStrategy = new IsRunningStartupCheckStrategy();
    private int startupAttempts = 1;
    @Nullable
    private String workingDirectory = null;
    @Nullable
    private Long shmSize;
    private Map<MountableFile, String> copyToFileContainerPathMap = new HashMap<MountableFile, String>();
    protected final Set<Startable> dependencies = new HashSet<Startable>();
    protected DockerClient dockerClient = DockerClientFactory.instance().client();
    protected Info dockerDaemonInfo = null;
    @Deprecated
    protected String containerId;
    @Deprecated
    protected String containerName;
    private InspectContainerResponse containerInfo;
    @NonNull
    protected org.testcontainers.containers.wait.strategy.WaitStrategy waitStrategy = Wait.defaultWaitStrategy();
    private List<Consumer<OutputFrame>> logConsumers = new ArrayList<Consumer<OutputFrame>>();
    private final Set<Consumer<CreateContainerCmd>> createContainerCmdModifiers = new LinkedHashSet<Consumer<CreateContainerCmd>>();
    private static final Set<String> AVAILABLE_IMAGE_NAME_CACHE = new HashSet<String>();
    private static final RateLimiter DOCKER_CLIENT_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(1, TimeUnit.SECONDS).withConstantThroughput().build();
    @Nullable
    private Map<String, String> tmpFsMapping;

    public GenericContainer() {
        this(TestcontainersConfiguration.getInstance().getTinyImage());
    }

    public GenericContainer(@NonNull String dockerImageName) {
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
        this.setDockerImageName(dockerImageName);
    }

    public GenericContainer(@NonNull Future<String> image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.image = image;
    }

    public SELF dependsOn(Startable ... startables) {
        Collections.addAll(this.dependencies, startables);
        return (SELF)((GenericContainer)this.self());
    }

    public SELF dependsOn(List<Startable> startables) {
        this.dependencies.addAll(startables);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void start() {
        if (this.containerId != null) {
            return;
        }
        Startables.deepStart(this.dependencies).get();
        this.doStart();
    }

    protected void doStart() {
        try {
            this.configure();
            this.logger().debug("Starting container: {}", (Object)this.getDockerImageName());
            this.logger().debug("Trying to start container: {}", (Object)this.image.get());
            AtomicInteger attempt = new AtomicInteger(0);
            Unreliables.retryUntilSuccess((int)this.startupAttempts, () -> {
                this.logger().debug("Trying to start container: {} (attempt {}/{})", new Object[]{this.image.get(), attempt.incrementAndGet(), this.startupAttempts});
                this.tryStart();
                return true;
            });
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Container startup failed", e);
        }
    }

    private void tryStart() {
        try {
            String dockerImageName = this.image.get();
            this.logger().debug("Starting container: {}", (Object)dockerImageName);
            this.logger().info("Creating container for image: {}", (Object)dockerImageName);
            CreateContainerCmd createCommand = this.dockerClient.createContainerCmd(dockerImageName);
            this.applyConfiguration(createCommand);
            this.containerId = createCommand.exec().getId();
            this.connectToPortForwardingNetwork(createCommand.getNetworkMode());
            this.copyToFileContainerPathMap.forEach(this::copyFileToContainer);
            this.containerIsCreated(this.containerId);
            this.logger().info("Starting container with ID: {}", (Object)this.containerId);
            this.dockerClient.startContainerCmd(this.containerId).exec();
            this.logger().info("Container {} is starting: {}", (Object)dockerImageName, (Object)this.containerId);
            this.logConsumers.forEach(this::followOutput);
            this.containerInfo = this.dockerClient.inspectContainerCmd(this.containerId).exec();
            this.containerName = this.containerInfo.getName();
            this.containerIsStarting(this.containerInfo);
            if (!this.startupCheckStrategy.waitUntilStartupSuccessful(this.dockerClient, this.containerId)) {
                throw new IllegalStateException("Container did not start correctly.");
            }
            this.waitUntilContainerStarted();
            this.logger().info("Container {} started", (Object)dockerImageName);
            this.containerIsStarted(this.containerInfo);
        }
        catch (Exception e) {
            this.logger().error("Could not start container", (Throwable)e);
            if (this.containerId != null) {
                String containerLogs = this.getLogs();
                if (containerLogs.length() > 0) {
                    this.logger().error("Log output from the failed container:\n{}", (Object)this.getLogs());
                } else {
                    this.logger().error("There are no stdout/stderr logs available for the failed container");
                }
            }
            throw new ContainerLaunchException("Could not create/start container", e);
        }
    }

    private HostConfig buildHostConfig() {
        HostConfig config = new HostConfig();
        if (this.shmSize != null) {
            config.withShmSize(this.shmSize);
        }
        if (this.tmpFsMapping != null) {
            config.withTmpFs(this.tmpFsMapping);
        }
        return config;
    }

    private void connectToPortForwardingNetwork(String networkMode) {
        PortForwardingContainer.INSTANCE.getNetwork().map(ContainerNetwork::getNetworkID).ifPresent(networkId -> {
            if (!Arrays.asList(networkId, "none", "host").contains(networkMode)) {
                this.dockerClient.connectToNetworkCmd().withContainerId(this.containerId).withNetworkId((String)networkId).exec();
            }
        });
    }

    @Override
    public void stop() {
        if (this.containerId == null) {
            return;
        }
        try {
            String imageName;
            try {
                imageName = this.image.get();
            }
            catch (Exception e) {
                imageName = "<unknown>";
            }
            this.containerIsStopping(this.containerInfo);
            ResourceReaper.instance().stopAndRemoveContainer(this.containerId, imageName);
            this.containerIsStopped(this.containerInfo);
        }
        finally {
            this.containerId = null;
            this.containerInfo = null;
        }
    }

    protected Logger logger() {
        return DockerLoggerFactory.getLogger(this.getDockerImageName());
    }

    protected Path createVolumeDirectory(boolean temporary) {
        Path directory = new File(".tmp-volume-" + System.currentTimeMillis()).toPath();
        PathUtils.mkdirp(directory);
        if (temporary) {
            Runtime.getRuntime().addShutdownHook(new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> PathUtils.recursiveDeleteDir(directory)));
        }
        return directory;
    }

    protected void configure() {
    }

    protected void containerIsCreated(String containerId) {
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
    }

    protected void containerIsStopped(InspectContainerResponse containerInfo) {
    }

    @Deprecated
    protected Integer getLivenessCheckPort() {
        if (this.exposedPorts.size() > 0) {
            return this.getMappedPort(this.exposedPorts.get(0));
        }
        if (this.portBindings.size() > 0) {
            return Integer.valueOf(PortBinding.parse(this.portBindings.get(0)).getBinding().getHostPortSpec());
        }
        return null;
    }

    @Deprecated
    @NotNull
    @NonNull
    protected Set<Integer> getLivenessCheckPorts() {
        Set<Integer> result = WaitStrategyTarget.super.getLivenessCheckPortNumbers();
        if (this.getLivenessCheckPort() != null) {
            result.add(this.getLivenessCheckPort());
        }
        return result;
    }

    @Override
    public Set<Integer> getLivenessCheckPortNumbers() {
        return this.getLivenessCheckPorts();
    }

    private void applyConfiguration(CreateContainerCmd createCommand) {
        Optional networkForLinks;
        boolean shouldCheckFileMountingSupport;
        HostConfig hostConfig = this.buildHostConfig();
        createCommand.withHostConfig(hostConfig);
        ExposedPort[] portArray = (ExposedPort[])this.exposedPorts.stream().map(ExposedPort::new).toArray(ExposedPort[]::new);
        createCommand.withExposedPorts(portArray);
        PortBinding[] portBindingArray = (PortBinding[])this.portBindings.stream().map(PortBinding::parse).toArray(PortBinding[]::new);
        createCommand.withPortBindings(portBindingArray);
        if (this.commandParts != null) {
            createCommand.withCmd(this.commandParts);
        }
        String[] envArray = (String[])this.env.entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).toArray(String[]::new);
        createCommand.withEnv(envArray);
        boolean bl = shouldCheckFileMountingSupport = this.binds.size() > 0 && !TestcontainersConfiguration.getInstance().isDisableChecks();
        if (shouldCheckFileMountingSupport && !DockerClientFactory.instance().isFileMountingSupported()) {
            VisibleAssertions.warn((String)"Unable to mount a file from test host into a running container. This may be a misconfiguration or limitation of your Docker environment. Some features might not work.");
        }
        Bind[] bindsArray = (Bind[])this.binds.stream().toArray(Bind[]::new);
        createCommand.withBinds(bindsArray);
        VolumesFrom[] volumesFromsArray = (VolumesFrom[])this.volumesFroms.stream().toArray(VolumesFrom[]::new);
        createCommand.withVolumesFrom(volumesFromsArray);
        HashSet<Link> allLinks = new HashSet<Link>();
        HashSet<String> allLinkedContainerNetworks = new HashSet<String>();
        for (Map.Entry<String, LinkableContainer> linkEntries : this.linkedContainers.entrySet()) {
            String alias = linkEntries.getKey();
            LinkableContainer linkableContainer = linkEntries.getValue();
            Set<Link> links = this.findLinksFromThisContainer(alias, linkableContainer);
            allLinks.addAll(links);
            if (allLinks.size() == 0) {
                throw new ContainerLaunchException("Aborting attempt to link to container " + linkableContainer.getContainerName() + " as it is not running");
            }
            Set<String> linkedContainerNetworks = this.findAllNetworksForLinkedContainers(linkableContainer);
            allLinkedContainerNetworks.addAll(linkedContainerNetworks);
        }
        createCommand.withLinks(allLinks.toArray(new Link[allLinks.size()]));
        allLinkedContainerNetworks.remove("bridge");
        if (allLinkedContainerNetworks.size() > 1) {
            this.logger().warn("Container needs to be on more than one custom network to link to other containers - this is not currently supported. Required networks are: {}", allLinkedContainerNetworks);
        }
        if ((networkForLinks = allLinkedContainerNetworks.stream().findFirst()).isPresent()) {
            this.logger().debug("Associating container with network: {}", networkForLinks.get());
            createCommand.withNetworkMode((String)networkForLinks.get());
        }
        createCommand.withPublishAllPorts(true);
        PortForwardingContainer.INSTANCE.getNetwork().ifPresent(it -> this.withExtraHost(INTERNAL_HOST_HOSTNAME, it.getIpAddress()));
        String[] extraHostsArray = (String[])this.extraHosts.stream().toArray(String[]::new);
        createCommand.withExtraHosts(extraHostsArray);
        if (this.network != null) {
            createCommand.withNetworkMode(this.network.getId());
            createCommand.withAliases(this.networkAliases);
        } else if (this.networkMode != null) {
            createCommand.withNetworkMode(this.networkMode);
        }
        if (this.workingDirectory != null) {
            createCommand.withWorkingDir(this.workingDirectory);
        }
        if (this.privilegedMode) {
            createCommand.withPrivileged(this.privilegedMode);
        }
        this.createContainerCmdModifiers.forEach(hook -> hook.accept(createCommand));
        HashMap<String, String> combinedLabels = new HashMap<String, String>();
        combinedLabels.putAll(this.labels);
        if (createCommand.getLabels() != null) {
            combinedLabels.putAll(createCommand.getLabels());
        }
        combinedLabels.putAll(DockerClientFactory.DEFAULT_LABELS);
        createCommand.withLabels(combinedLabels);
    }

    private Set<Link> findLinksFromThisContainer(String alias, LinkableContainer linkableContainer) {
        return ((List)this.dockerClient.listContainersCmd().withStatusFilter(Arrays.asList("running")).exec()).stream().flatMap(container -> Stream.of(container.getNames())).filter(name -> name.endsWith(linkableContainer.getContainerName())).map(name -> new Link((String)name, alias)).collect(Collectors.toSet());
    }

    private Set<String> findAllNetworksForLinkedContainers(LinkableContainer linkableContainer) {
        return ((List)this.dockerClient.listContainersCmd().exec()).stream().filter(container -> container.getNames()[0].endsWith(linkableContainer.getContainerName())).filter(container -> container.getNetworkSettings() != null && container.getNetworkSettings().getNetworks() != null).flatMap(container -> container.getNetworkSettings().getNetworks().keySet().stream()).distinct().collect(Collectors.toSet());
    }

    @Override
    public SELF waitingFor(@NonNull org.testcontainers.containers.wait.strategy.WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked non-null but is null");
        }
        this.waitStrategy = waitStrategy;
        return (SELF)((GenericContainer)this.self());
    }

    protected org.testcontainers.containers.wait.strategy.WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    @Override
    public void setWaitStrategy(org.testcontainers.containers.wait.strategy.WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    protected void waitUntilContainerStarted() {
        org.testcontainers.containers.wait.strategy.WaitStrategy waitStrategy = this.getWaitStrategy();
        if (waitStrategy != null) {
            waitStrategy.waitUntilReady(this);
        }
    }

    @Override
    public void setCommand(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        this.commandParts = command.split(" ");
    }

    @Override
    public void setCommand(String ... commandParts) {
        if (commandParts == null) {
            throw new NullPointerException("commandParts is marked non-null but is null");
        }
        this.commandParts = commandParts;
    }

    @Override
    public Map<String, String> getEnvMap() {
        return this.env;
    }

    @Override
    public List<String> getEnv() {
        return this.env.entrySet().stream().map(it -> (String)it.getKey() + "=" + (String)it.getValue()).collect(Collectors.toList());
    }

    @Override
    public void setEnv(List<String> env) {
        this.env = env.stream().map(it -> it.split("=")).collect(Collectors.toMap(it -> it[0], it -> it[1]));
    }

    @Override
    public void addEnv(String key, String value) {
        this.env.put(key, value);
    }

    @Override
    public void addFileSystemBind(String hostPath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        MountableFile mountableFile = MountableFile.forHostPath(hostPath);
        this.binds.add(new Bind(mountableFile.getResolvedPath(), new Volume(containerPath), mode.accessMode, selinuxContext.selContext));
    }

    @Override
    public SELF withFileSystemBind(String hostPath, String containerPath, BindMode mode) {
        this.addFileSystemBind(hostPath, containerPath, mode);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withVolumesFrom(Container container, BindMode mode) {
        this.addVolumesFrom(container, mode);
        return (SELF)((GenericContainer)this.self());
    }

    private void addVolumesFrom(Container container, BindMode mode) {
        this.volumesFroms.add(new VolumesFrom(container.getContainerName(), mode.accessMode));
    }

    @Override
    @Deprecated
    public void addLink(LinkableContainer otherContainer, String alias) {
        this.linkedContainers.put(alias, otherContainer);
    }

    @Override
    public void addExposedPort(Integer port) {
        this.exposedPorts.add(port);
    }

    @Override
    public void addExposedPorts(int ... ports) {
        for (int port : ports) {
            this.exposedPorts.add(port);
        }
    }

    private TestDescription toDescription(final Description description) {
        return new TestDescription(){

            @Override
            public String getTestId() {
                return description.getDisplayName();
            }

            @Override
            public String getFilesystemFriendlyName() {
                return description.getClassName() + "-" + description.getMethodName();
            }
        };
    }

    @Override
    @Deprecated
    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    @Override
    @Deprecated
    protected void starting(Description description) {
        if (this instanceof TestLifecycleAware) {
            ((TestLifecycleAware)((Object)this)).beforeTest(this.toDescription(description));
        }
        this.start();
    }

    @Override
    @Deprecated
    protected void succeeded(Description description) {
        if (this instanceof TestLifecycleAware) {
            ((TestLifecycleAware)((Object)this)).afterTest(this.toDescription(description), Optional.empty());
        }
    }

    @Override
    @Deprecated
    protected void failed(Throwable e, Description description) {
        if (this instanceof TestLifecycleAware) {
            ((TestLifecycleAware)((Object)this)).afterTest(this.toDescription(description), Optional.of(e));
        }
    }

    @Override
    @Deprecated
    protected void finished(Description description) {
        this.stop();
    }

    @Override
    public SELF withExposedPorts(Integer ... ports) {
        this.setExposedPorts(Lists.newArrayList(ports));
        return (SELF)((GenericContainer)this.self());
    }

    protected void addFixedExposedPort(int hostPort, int containerPort) {
        this.addFixedExposedPort(hostPort, containerPort, InternetProtocol.TCP);
    }

    protected void addFixedExposedPort(int hostPort, int containerPort, InternetProtocol protocol) {
        this.portBindings.add(String.format("%d:%d/%s", hostPort, containerPort, protocol.toDockerNotation()));
    }

    @Override
    public SELF withEnv(String key, String value) {
        this.addEnv(key, value);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withEnv(Map<String, String> env) {
        env.forEach(this::addEnv);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withLabel(String key, String value) {
        if (key.startsWith("org.testcontainers")) {
            throw new IllegalArgumentException("The org.testcontainers namespace is reserved for interal use");
        }
        this.labels.put(key, value);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withLabels(Map<String, String> labels) {
        labels.forEach((string, string2) -> this.withLabel((String)string, (String)string2));
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCommand(String cmd) {
        this.setCommand(cmd);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCommand(String ... commandParts) {
        this.setCommand(commandParts);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withExtraHost(String hostname, String ipAddress) {
        this.extraHosts.add(String.format("%s:%s", hostname, ipAddress));
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetworkMode(String networkMode) {
        this.networkMode = networkMode;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetwork(Network network) {
        this.network = network;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withNetworkAliases(String ... aliases) {
        Collections.addAll(this.networkAliases, aliases);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode) {
        return (SELF)this.withClasspathResourceMapping(resourcePath, containerPath, mode, SelinuxContext.NONE);
    }

    @Override
    public SELF withClasspathResourceMapping(String resourcePath, String containerPath, BindMode mode, SelinuxContext selinuxContext) {
        MountableFile mountableFile = MountableFile.forClasspathResource(resourcePath);
        if (mode == BindMode.READ_ONLY && selinuxContext == SelinuxContext.NONE) {
            this.withCopyFileToContainer(mountableFile, containerPath);
        } else {
            this.addFileSystemBind(mountableFile.getResolvedPath(), containerPath, mode, selinuxContext);
        }
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withStartupTimeout(Duration startupTimeout) {
        this.getWaitStrategy().withStartupTimeout(startupTimeout);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withPrivilegedMode(boolean mode) {
        this.privilegedMode = mode;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withMinimumRunningDuration(Duration minimumRunningDuration) {
        this.startupCheckStrategy = new MinimumDurationRunningStartupCheckStrategy(minimumRunningDuration);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withStartupCheckStrategy(StartupCheckStrategy strategy) {
        this.startupCheckStrategy = strategy;
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withWorkingDirectory(String workDir) {
        this.setWorkingDirectory(workDir);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public SELF withCopyFileToContainer(MountableFile mountableFile, String containerPath) {
        this.copyToFileContainerPathMap.put(mountableFile, containerPath);
        return (SELF)((GenericContainer)this.self());
    }

    @Deprecated
    public String getIpAddress() {
        return this.getContainerIpAddress();
    }

    @Override
    public void setDockerImageName(@NonNull String dockerImageName) {
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
        this.image = new RemoteDockerImage(dockerImageName);
        this.getDockerImageName();
    }

    @Override
    @NonNull
    public String getDockerImageName() {
        try {
            return this.image.get();
        }
        catch (Exception e) {
            throw new ContainerFetchException("Can't get Docker image: " + this.image, e);
        }
    }

    @Override
    public String getTestHostIpAddress() {
        if (DockerMachineClient.instance().isInstalled()) {
            try {
                Optional<String> defaultMachine = DockerMachineClient.instance().getDefaultMachine();
                if (!defaultMachine.isPresent()) {
                    throw new IllegalStateException("Could not find a default docker-machine instance");
                }
                String sshConnectionString = CommandLine.runShellCommand("docker-machine", "ssh", defaultMachine.get(), "echo $SSH_CONNECTION").trim();
                if (Strings.isNullOrEmpty(sshConnectionString)) {
                    throw new IllegalStateException("Could not obtain SSH_CONNECTION environment variable for docker machine " + defaultMachine.get());
                }
                String[] sshConnectionParts = sshConnectionString.split("\\s");
                if (sshConnectionParts.length != 4) {
                    throw new IllegalStateException("Unexpected pattern for SSH_CONNECTION for docker machine - expected 'IP PORT IP PORT' pattern but found '" + sshConnectionString + "'");
                }
                return sshConnectionParts[0];
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new UnsupportedOperationException("getTestHostIpAddress() is only implemented for docker-machine right now");
    }

    @Override
    public SELF withLogConsumer(Consumer<OutputFrame> consumer) {
        this.logConsumers.add(consumer);
        return (SELF)((GenericContainer)this.self());
    }

    @Override
    public synchronized Info fetchDockerDaemonInfo() throws IOException {
        if (this.dockerDaemonInfo == null) {
            this.dockerDaemonInfo = (Info)this.dockerClient.infoCmd().exec();
        }
        return this.dockerDaemonInfo;
    }

    @Override
    public Container.ExecResult execInContainer(String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return this.execInContainer(UTF8, command);
    }

    @Override
    public void copyFileToContainer(MountableFile mountableFile, String containerPath) {
        File sourceFile = new File(mountableFile.getResolvedPath());
        if (containerPath.endsWith("/") && sourceFile.isFile()) {
            this.logger().warn("folder-like containerPath in copyFileToContainer is deprecated, please explicitly specify a file path");
            this.copyFileToContainer((Transferable)mountableFile, containerPath + sourceFile.getName());
        } else {
            this.copyFileToContainer((Transferable)mountableFile, containerPath);
        }
    }

    @Override
    public void copyFileToContainer(Transferable transferable, String containerPath) {
        if (!this.isCreated()) {
            throw new IllegalStateException("copyFileToContainer can only be used with created / running container");
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             TarArchiveOutputStream tarArchive = new TarArchiveOutputStream((OutputStream)byteArrayOutputStream);){
            tarArchive.setLongFileMode(3);
            int lastSlashIndex = StringUtils.removeEnd(containerPath, "/").lastIndexOf("/");
            String extractArchiveTo = containerPath.substring(0, lastSlashIndex + 1);
            String pathInArchive = containerPath.substring(lastSlashIndex + 1);
            transferable.transferTo(tarArchive, pathInArchive);
            tarArchive.finish();
            this.dockerClient.copyArchiveToContainerCmd(this.containerId).withTarInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).withRemotePath(extractArchiveTo).exec();
        }
    }

    @Override
    public void copyFileFromContainer(String containerPath, String destinationPath) {
        this.copyFileFromContainer(containerPath, (InputStream inputStream) -> {
            try (FileOutputStream output = new FileOutputStream(destinationPath);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)output);
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T copyFileFromContainer(String containerPath, ThrowingFunction<InputStream, T> consumer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Container.ExecResult execInContainer(Charset outputCharset, String ... command) throws UnsupportedOperationException, IOException, InterruptedException {
        return ExecInContainerPattern.execInContainer(this.getContainerInfo(), outputCharset, command);
    }

    public SELF withStartupAttempts(int attempts) {
        this.startupAttempts = attempts;
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withCreateContainerCmdModifier(Consumer<CreateContainerCmd> modifier) {
        this.createContainerCmdModifiers.add(modifier);
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withSharedMemorySize(Long bytes) {
        this.shmSize = bytes;
        return (SELF)((GenericContainer)this.self());
    }

    public SELF withTmpFs(Map<String, String> mapping) {
        this.tmpFsMapping = mapping;
        return (SELF)((GenericContainer)this.self());
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    @NonNull
    public List<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    @NonNull
    public List<String> getPortBindings() {
        return this.portBindings;
    }

    @Override
    @NonNull
    public List<String> getExtraHosts() {
        return this.extraHosts;
    }

    @NonNull
    public String getNetworkMode() {
        return this.networkMode;
    }

    @NonNull
    public Network getNetwork() {
        return this.network;
    }

    @NonNull
    public List<String> getNetworkAliases() {
        return this.networkAliases;
    }

    @Override
    @NonNull
    public Future<String> getImage() {
        return this.image;
    }

    @NonNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    @NonNull
    public String[] getCommandParts() {
        return this.commandParts;
    }

    @Override
    @NonNull
    public List<Bind> getBinds() {
        return this.binds;
    }

    public boolean isPrivilegedMode() {
        return this.privilegedMode;
    }

    @NonNull
    public List<VolumesFrom> getVolumesFroms() {
        return this.volumesFroms;
    }

    @Override
    @Deprecated
    @NonNull
    public Map<String, LinkableContainer> getLinkedContainers() {
        return this.linkedContainers;
    }

    public StartupCheckStrategy getStartupCheckStrategy() {
        return this.startupCheckStrategy;
    }

    public int getStartupAttempts() {
        return this.startupAttempts;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public Long getShmSize() {
        return this.shmSize;
    }

    public Map<MountableFile, String> getCopyToFileContainerPathMap() {
        return this.copyToFileContainerPathMap;
    }

    @Override
    public Set<Startable> getDependencies() {
        return this.dependencies;
    }

    @Override
    public DockerClient getDockerClient() {
        return this.dockerClient;
    }

    @Override
    public Info getDockerDaemonInfo() {
        return this.dockerDaemonInfo;
    }

    @Override
    @Deprecated
    public String getContainerName() {
        return this.containerName;
    }

    @Override
    public InspectContainerResponse getContainerInfo() {
        return this.containerInfo;
    }

    public List<Consumer<OutputFrame>> getLogConsumers() {
        return this.logConsumers;
    }

    public Set<Consumer<CreateContainerCmd>> getCreateContainerCmdModifiers() {
        return this.createContainerCmdModifiers;
    }

    @Nullable
    public Map<String, String> getTmpFsMapping() {
        return this.tmpFsMapping;
    }

    @Override
    public void setExposedPorts(@NonNull List<Integer> exposedPorts) {
        if (exposedPorts == null) {
            throw new NullPointerException("exposedPorts is marked non-null but is null");
        }
        this.exposedPorts = exposedPorts;
    }

    @Override
    public void setPortBindings(@NonNull List<String> portBindings) {
        if (portBindings == null) {
            throw new NullPointerException("portBindings is marked non-null but is null");
        }
        this.portBindings = portBindings;
    }

    @Override
    public void setExtraHosts(@NonNull List<String> extraHosts) {
        if (extraHosts == null) {
            throw new NullPointerException("extraHosts is marked non-null but is null");
        }
        this.extraHosts = extraHosts;
    }

    public void setNetworkMode(@NonNull String networkMode) {
        if (networkMode == null) {
            throw new NullPointerException("networkMode is marked non-null but is null");
        }
        this.networkMode = networkMode;
    }

    public void setNetwork(@NonNull Network network) {
        if (network == null) {
            throw new NullPointerException("network is marked non-null but is null");
        }
        this.network = network;
    }

    public void setNetworkAliases(@NonNull List<String> networkAliases) {
        if (networkAliases == null) {
            throw new NullPointerException("networkAliases is marked non-null but is null");
        }
        this.networkAliases = networkAliases;
    }

    @Override
    public void setImage(@NonNull Future<String> image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        this.image = image;
    }

    public void setLabels(@NonNull Map<String, String> labels) {
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.labels = labels;
    }

    @Override
    public void setCommandParts(@NonNull String[] commandParts) {
        if (commandParts == null) {
            throw new NullPointerException("commandParts is marked non-null but is null");
        }
        this.commandParts = commandParts;
    }

    @Override
    public void setBinds(@NonNull List<Bind> binds) {
        if (binds == null) {
            throw new NullPointerException("binds is marked non-null but is null");
        }
        this.binds = binds;
    }

    public void setPrivilegedMode(boolean privilegedMode) {
        this.privilegedMode = privilegedMode;
    }

    public void setVolumesFroms(@NonNull List<VolumesFrom> volumesFroms) {
        if (volumesFroms == null) {
            throw new NullPointerException("volumesFroms is marked non-null but is null");
        }
        this.volumesFroms = volumesFroms;
    }

    @Override
    @Deprecated
    public void setLinkedContainers(@NonNull Map<String, LinkableContainer> linkedContainers) {
        if (linkedContainers == null) {
            throw new NullPointerException("linkedContainers is marked non-null but is null");
        }
        this.linkedContainers = linkedContainers;
    }

    public void setStartupCheckStrategy(StartupCheckStrategy startupCheckStrategy) {
        this.startupCheckStrategy = startupCheckStrategy;
    }

    public void setStartupAttempts(int startupAttempts) {
        this.startupAttempts = startupAttempts;
    }

    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setShmSize(@Nullable Long shmSize) {
        this.shmSize = shmSize;
    }

    public void setCopyToFileContainerPathMap(Map<MountableFile, String> copyToFileContainerPathMap) {
        this.copyToFileContainerPathMap = copyToFileContainerPathMap;
    }

    public void setLogConsumers(List<Consumer<OutputFrame>> logConsumers) {
        this.logConsumers = logConsumers;
    }

    public void setTmpFsMapping(@Nullable Map<String, String> tmpFsMapping) {
        this.tmpFsMapping = tmpFsMapping;
    }

    public String toString() {
        return "GenericContainer(exposedPorts=" + this.getExposedPorts() + ", portBindings=" + this.getPortBindings() + ", extraHosts=" + this.getExtraHosts() + ", networkMode=" + this.getNetworkMode() + ", network=" + this.getNetwork() + ", networkAliases=" + this.getNetworkAliases() + ", image=" + this.getImage() + ", env=" + this.getEnv() + ", labels=" + this.getLabels() + ", commandParts=" + Arrays.deepToString(this.getCommandParts()) + ", binds=" + this.getBinds() + ", privilegedMode=" + this.isPrivilegedMode() + ", volumesFroms=" + this.getVolumesFroms() + ", linkedContainers=" + this.getLinkedContainers() + ", startupCheckStrategy=" + this.getStartupCheckStrategy() + ", startupAttempts=" + this.getStartupAttempts() + ", workingDirectory=" + this.getWorkingDirectory() + ", shmSize=" + this.getShmSize() + ", copyToFileContainerPathMap=" + this.getCopyToFileContainerPathMap() + ", dependencies=" + this.getDependencies() + ", dockerClient=" + this.getDockerClient() + ", dockerDaemonInfo=" + this.getDockerDaemonInfo() + ", containerId=" + this.getContainerId() + ", containerName=" + this.getContainerName() + ", containerInfo=" + this.getContainerInfo() + ", waitStrategy=" + this.getWaitStrategy() + ", logConsumers=" + this.getLogConsumers() + ", createContainerCmdModifiers=" + this.getCreateContainerCmdModifiers() + ", tmpFsMapping=" + this.getTmpFsMapping() + ")";
    }

    @Deprecated
    public static abstract class AbstractWaitStrategy
    extends org.testcontainers.containers.wait.strategy.AbstractWaitStrategy
    implements WaitStrategy {
        protected GenericContainer container;
        @NonNull
        protected Duration startupTimeout = Duration.ofSeconds(60L);

        @Override
        public void waitUntilReady(GenericContainer container) {
            this.container = container;
            this.waitUntilReady();
        }

        @Override
        protected abstract void waitUntilReady();

        @Override
        public WaitStrategy withStartupTimeout(Duration startupTimeout) {
            this.startupTimeout = startupTimeout;
            return this;
        }

        protected Logger logger() {
            return this.container.logger();
        }

        @Deprecated
        protected Integer getLivenessCheckPort() {
            return this.container.getLivenessCheckPort();
        }

        @Override
        protected Set<Integer> getLivenessCheckPorts() {
            return this.container.getLivenessCheckPorts();
        }

        @Override
        protected RateLimiter getRateLimiter() {
            return DOCKER_CLIENT_RATE_LIMITER;
        }
    }
}

