/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.internal;

import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ExecInContainerPattern;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public class InternalCommandPortListeningCheck
implements Callable<Boolean> {
    private static final Logger log = LoggerFactory.getLogger(InternalCommandPortListeningCheck.class);
    private final WaitStrategyTarget waitStrategyTarget;
    private final Set<Integer> internalPorts;

    @Override
    public Boolean call() {
        String command = "true";
        for (int internalPort : this.internalPorts) {
            command = command + " && ";
            command = command + " (";
            command = command + String.format("cat /proc/net/tcp{,6} | awk '{print $2}' | grep -i :%x", internalPort);
            command = command + " || ";
            command = command + String.format("nc -vz -w 1 localhost %d", internalPort);
            command = command + " || ";
            command = command + String.format("/bin/bash -c '</dev/tcp/localhost/%d'", internalPort);
            command = command + ")";
        }
        Instant before = Instant.now();
        try {
            Container.ExecResult result = ExecInContainerPattern.execInContainer(this.waitStrategyTarget.getContainerInfo(), "/bin/sh", "-c", command);
            log.trace("Check for {} took {}", this.internalPorts, (Object)Duration.between(before, Instant.now()));
            return result.getExitCode() == 0;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public InternalCommandPortListeningCheck(WaitStrategyTarget waitStrategyTarget, Set<Integer> internalPorts) {
        this.waitStrategyTarget = waitStrategyTarget;
        this.internalPorts = internalPorts;
    }
}

