/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.SSLConfig;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.shaded.org.apache.commons.lang.SystemUtils;

public class NpipeSocketClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(NpipeSocketClientProviderStrategy.class);
    protected static final String DOCKER_SOCK_PATH = "//./pipe/docker_engine";
    private static final String SOCKET_LOCATION = "npipe:////./pipe/docker_engine";
    private static final String PING_TIMEOUT_DEFAULT = "10";
    private static final String PING_TIMEOUT_PROPERTY_NAME = "testcontainers.npipesocketprovider.timeout";
    public static final int PRIORITY = 80;

    @Override
    protected boolean isApplicable() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @Override
    public void test() throws InvalidConfigurationException {
        try {
            this.config = this.tryConfiguration();
            log.info("Accessing docker with {}", (Object)this.getDescription());
        }
        catch (Exception | UnsatisfiedLinkError e) {
            throw new InvalidConfigurationException("ping failed", e);
        }
    }

    @NotNull
    private DockerClientConfig tryConfiguration() {
        final URI dockerHost = URI.create(SOCKET_LOCATION);
        this.config = new DelegatingDockerClientConfig(DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost("tcp://localhost:0").withDockerTlsVerify(false).build()){

            @Override
            public URI getDockerHost() {
                return dockerHost;
            }
        };
        this.client = this.getClientForConfig(this.config);
        int timeout = Integer.parseInt(System.getProperty(PING_TIMEOUT_PROPERTY_NAME, PING_TIMEOUT_DEFAULT));
        this.ping(this.client, timeout);
        return this.config;
    }

    @Override
    public String getDescription() {
        return "local Npipe socket (npipe:////./pipe/docker_engine)";
    }

    @Override
    protected int getPriority() {
        return 80;
    }

    private static class DelegatingDockerClientConfig
    implements DockerClientConfig {
        final DockerClientConfig dockerClientConfig;

        public DelegatingDockerClientConfig(DockerClientConfig dockerClientConfig) {
            this.dockerClientConfig = dockerClientConfig;
        }

        @Override
        public URI getDockerHost() {
            return this.dockerClientConfig.getDockerHost();
        }

        @Override
        public RemoteApiVersion getApiVersion() {
            return this.dockerClientConfig.getApiVersion();
        }

        @Override
        public String getRegistryUsername() {
            return this.dockerClientConfig.getRegistryUsername();
        }

        @Override
        public String getRegistryPassword() {
            return this.dockerClientConfig.getRegistryPassword();
        }

        @Override
        public String getRegistryEmail() {
            return this.dockerClientConfig.getRegistryEmail();
        }

        @Override
        public String getRegistryUrl() {
            return this.dockerClientConfig.getRegistryUrl();
        }

        @Override
        public AuthConfig effectiveAuthConfig(String arg0) {
            return this.dockerClientConfig.effectiveAuthConfig(arg0);
        }

        @Override
        public AuthConfigurations getAuthConfigurations() {
            return this.dockerClientConfig.getAuthConfigurations();
        }

        @Override
        public SSLConfig getSSLConfig() {
            return this.dockerClientConfig.getSSLConfig();
        }
    }
}

