/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient.transport.okhttp;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.BadRequestException;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotAcceptableException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.okhttp3.HttpUrl;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.RequestBody;
import org.testcontainers.shaded.okhttp3.Response;
import org.testcontainers.shaded.okhttp3.internal.connection.RealConnection;
import org.testcontainers.shaded.okio.BufferedSink;
import org.testcontainers.shaded.okio.BufferedSource;
import org.testcontainers.shaded.okio.Okio;
import org.testcontainers.shaded.okio.Source;

class OkHttpInvocationBuilder
implements InvocationBuilder {
    private static final Logger log = LoggerFactory.getLogger(OkHttpInvocationBuilder.class);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final Request.Builder requestBuilder;

    public OkHttpInvocationBuilder(ObjectMapper objectMapper, OkHttpClient okHttpClient, HttpUrl httpUrl) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.requestBuilder = new Request.Builder().url(httpUrl);
    }

    @Override
    public OkHttpInvocationBuilder accept(MediaType mediaType) {
        return this.header("accept", mediaType.getMediaType());
    }

    @Override
    public OkHttpInvocationBuilder header(String name, String value) {
        this.requestBuilder.header(name, value);
        return this;
    }

    @Override
    public void delete() {
        Request request = this.requestBuilder.delete().build();
        this.execute(request).close();
    }

    @Override
    public void get(ResultCallback<Frame> resultCallback) {
        Request request = this.requestBuilder.get().build();
        this.executeAndStream(request, resultCallback, new FramedSink(resultCallback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(TypeReference<T> typeReference) {
        try (InputStream inputStream = this.get();){
            Object t = this.objectMapper.readValue(inputStream, typeReference);
            return t;
        }
    }

    @Override
    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        throw new IllegalStateException("doesn't seem to be used in docker-java");
    }

    @Override
    public InputStream post(Object entity) {
        Request request = this.requestBuilder.post(RequestBody.create(org.testcontainers.shaded.okhttp3.MediaType.parse("application/json"), this.objectMapper.writeValueAsBytes(entity))).build();
        return this.execute(request).body().byteStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(Object entity, TypeReference<T> typeReference) {
        Request request = this.requestBuilder.post(RequestBody.create(org.testcontainers.shaded.okhttp3.MediaType.parse("application/json"), this.objectMapper.writeValueAsBytes(entity))).build();
        try (Response response = this.execute(request);){
            String inputStream = response.body().string();
            Object t = this.objectMapper.readValue(inputStream, typeReference);
            return t;
        }
    }

    @Override
    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        this.post(typeReference, resultCallback, new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(entity)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        try (InputStream inputStream = this.post(body);){
            Object t = this.objectMapper.readValue(inputStream, typeReference);
            return t;
        }
    }

    @Override
    public void post(Object entity, final InputStream stdin, ResultCallback<Frame> resultCallback) {
        Request request = this.requestBuilder.post(RequestBody.create(org.testcontainers.shaded.okhttp3.MediaType.parse("application/json"), this.objectMapper.writeValueAsBytes(entity))).build();
        OkHttpClient okHttpClient = this.okHttpClient;
        if (stdin != null) {
            okHttpClient = okHttpClient.newBuilder().addNetworkInterceptor(chain -> {
                Response response = chain.proceed(chain.request());
                if (response.isSuccessful()) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            Field sinkField = RealConnection.class.getDeclaredField("sink");
                            sinkField.setAccessible(true);
                            try (BufferedSink sink = (BufferedSink)sinkField.get(chain.connection());
                                 Source source = Okio.source(stdin);){
                                sink.writeAll(source);
                            }
                        }
                    };
                    thread.start();
                }
                return response;
            }).build();
        }
        this.executeAndStream(okHttpClient, request, resultCallback, new FramedSink(resultCallback));
    }

    @Override
    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        Request request = this.requestBuilder.post(this.toRequestBody(body, null)).build();
        this.executeAndStream(request, resultCallback, new JsonSink<T>(this.objectMapper, typeReference, resultCallback));
    }

    @Override
    public void postStream(InputStream body) {
        Request request = this.requestBuilder.post(this.toRequestBody(body, null)).build();
        this.execute(request).close();
    }

    @Override
    public InputStream get() {
        Request request = this.requestBuilder.get().build();
        return this.execute(request).body().byteStream();
    }

    @Override
    public void put(InputStream body, MediaType mediaType) {
        Request request = this.requestBuilder.put(this.toRequestBody(body, mediaType.toString())).build();
        this.execute(request).close();
    }

    protected RequestBody toRequestBody(final InputStream body, final @Nullable String mediaType) {
        return new RequestBody(){

            @Override
            @Nullable
            public org.testcontainers.shaded.okhttp3.MediaType contentType() {
                if (mediaType == null) {
                    return null;
                }
                return org.testcontainers.shaded.okhttp3.MediaType.parse(mediaType);
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                try (Source source = Okio.source(body);){
                    sink.writeAll(source);
                }
            }
        };
    }

    protected Response execute(Request request) {
        return this.execute(this.okHttpClient, request);
    }

    protected Response execute(OkHttpClient okHttpClient, Request request) {
        Response response = okHttpClient.newCall(request).execute();
        if (!response.isSuccessful()) {
            String body = response.body().string();
            switch (response.code()) {
                case 304: {
                    throw new NotModifiedException(body);
                }
                case 400: {
                    throw new BadRequestException(body);
                }
                case 401: {
                    throw new UnauthorizedException(body);
                }
                case 404: {
                    throw new NotFoundException(body);
                }
                case 406: {
                    throw new NotAcceptableException(body);
                }
                case 409: {
                    throw new ConflictException(body);
                }
                case 500: {
                    throw new InternalServerErrorException(body);
                }
            }
            throw new DockerException(body, response.code());
        }
        return response;
    }

    protected <T> void executeAndStream(Request request, ResultCallback<T> callback, Consumer<BufferedSource> sourceConsumer) {
        this.executeAndStream(this.okHttpClient, request, callback, sourceConsumer);
    }

    protected <T> void executeAndStream(OkHttpClient okHttpClient, Request request, ResultCallback<T> callback, Consumer<BufferedSource> sourceConsumer) {
        Thread thread = new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> {
            try (Response response = this.execute(okHttpClient, request.newBuilder().tag("streaming").build());
                 BufferedSource source = response.body().source();){
                callback.onStart(response);
                sourceConsumer.accept(source);
                callback.onComplete();
            }
            catch (Exception e) {
                callback.onError(e);
            }
        }, "tc-okhttp-stream-" + Objects.hashCode(request));
        thread.setDaemon(true);
        thread.start();
    }

    private static class FramedSink
    implements Consumer<BufferedSource> {
        private static final int HEADER_SIZE = 8;
        private final ResultCallback<Frame> resultCallback;

        @Override
        public void accept(BufferedSource source) {
            try {
                while (!source.exhausted()) {
                    if (!source.request(8L)) {
                        return;
                    }
                    StreamType streamType = FramedSink.streamType(source.readByte());
                    source.skip(3L);
                    int payloadSize = source.readInt();
                    if (streamType != StreamType.RAW) {
                        if (!source.request(payloadSize)) {
                            return;
                        }
                        byte[] payload = source.readByteArray(payloadSize);
                        this.resultCallback.onNext(new Frame(streamType, payload));
                        continue;
                    }
                    this.resultCallback.onNext(new Frame(streamType, source.readByteArray()));
                }
            }
            catch (Exception e) {
                this.resultCallback.onError(e);
            }
        }

        private static StreamType streamType(byte streamType) {
            switch (streamType) {
                case 0: {
                    return StreamType.STDIN;
                }
                case 1: {
                    return StreamType.STDOUT;
                }
                case 2: {
                    return StreamType.STDERR;
                }
            }
            return StreamType.RAW;
        }

        public FramedSink(ResultCallback<Frame> resultCallback) {
            this.resultCallback = resultCallback;
        }
    }

    private static class JsonSink<T>
    implements Consumer<BufferedSource> {
        private final ObjectMapper objectMapper;
        private final TypeReference<T> typeReference;
        private final ResultCallback<T> resultCallback;

        @Override
        public void accept(BufferedSource source) {
            try {
                String line;
                while ((line = source.readUtf8Line()) != null) {
                    this.resultCallback.onNext(this.objectMapper.readValue(line, this.typeReference));
                }
            }
            catch (Exception e) {
                this.resultCallback.onError(e);
            }
        }

        public JsonSink(ObjectMapper objectMapper, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
            this.objectMapper = objectMapper;
            this.typeReference = typeReference;
            this.resultCallback = resultCallback;
        }
    }
}

