/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient.transport.okhttp;

import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.WebTarget;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.testcontainers.dockerclient.transport.okhttp.OkHttpInvocationBuilder;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.testcontainers.shaded.com.google.common.collect.HashMultimap;
import org.testcontainers.shaded.com.google.common.collect.ImmutableList;
import org.testcontainers.shaded.com.google.common.collect.SetMultimap;
import org.testcontainers.shaded.okhttp3.HttpUrl;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;

final class OkHttpWebTarget
implements WebTarget {
    private static final ObjectMapper MAPPER = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final OkHttpClient okHttpClient;
    private final HttpUrl baseUrl;
    private final ImmutableList<String> path;
    private final SetMultimap<String, String> queryParams;

    @Override
    public InvocationBuilder request() {
        String resource = StringUtils.join(this.path, "/");
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        HttpUrl.Builder baseUrlBuilder = this.baseUrl.newBuilder().encodedPath(resource);
        for (Map.Entry<String, Collection<String>> queryParamEntry : this.queryParams.asMap().entrySet()) {
            String key = queryParamEntry.getKey();
            for (String paramValue : queryParamEntry.getValue()) {
                baseUrlBuilder.addQueryParameter(key, paramValue);
            }
        }
        return new OkHttpInvocationBuilder(MAPPER, this.okHttpClient, baseUrlBuilder.build());
    }

    @Override
    public OkHttpWebTarget path(String ... components) {
        return this.withPath((ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.path)).add(components)).build());
    }

    @Override
    public OkHttpWebTarget resolveTemplate(String name, Object value) {
        ImmutableList.Builder newPath = ImmutableList.builder();
        for (String component : this.path) {
            component = component.replaceAll("\\{" + name + "\\}", value.toString());
            newPath.add(component);
        }
        return this.withPath((ImmutableList<String>)newPath.build());
    }

    @Override
    public OkHttpWebTarget queryParam(String name, Object value) {
        if (value == null) {
            return this;
        }
        HashMultimap<String, String> newQueryParams = HashMultimap.create(this.queryParams);
        newQueryParams.put(name, value.toString());
        return this.withQueryParams(newQueryParams);
    }

    @Override
    public OkHttpWebTarget queryParamsSet(String name, Set<?> values) {
        HashMultimap<String, String> newQueryParams = HashMultimap.create(this.queryParams);
        newQueryParams.replaceValues(name, (Iterable<String>)values.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
        return this.withQueryParams(newQueryParams);
    }

    @Override
    public OkHttpWebTarget queryParamsJsonMap(String name, Map<String, String> values) {
        if (values == null || values.isEmpty()) {
            return this;
        }
        return this.queryParam(name, MAPPER.writeValueAsString(values));
    }

    public OkHttpWebTarget(OkHttpClient okHttpClient, HttpUrl baseUrl, ImmutableList<String> path, SetMultimap<String, String> queryParams) {
        this.okHttpClient = okHttpClient;
        this.baseUrl = baseUrl;
        this.path = path;
        this.queryParams = queryParams;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    public ImmutableList<String> getPath() {
        return this.path;
    }

    public SetMultimap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkHttpWebTarget)) {
            return false;
        }
        OkHttpWebTarget other = (OkHttpWebTarget)o;
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        HttpUrl this$baseUrl = this.getBaseUrl();
        HttpUrl other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !((Object)this$baseUrl).equals(other$baseUrl)) {
            return false;
        }
        ImmutableList<String> this$path = this.getPath();
        ImmutableList<String> other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        SetMultimap<String, String> this$queryParams = this.getQueryParams();
        SetMultimap<String, String> other$queryParams = other.getQueryParams();
        return !(this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        HttpUrl $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : ((Object)$baseUrl).hashCode());
        ImmutableList<String> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        SetMultimap<String, String> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : $queryParams.hashCode());
        return result;
    }

    public String toString() {
        return "OkHttpWebTarget(okHttpClient=" + this.getOkHttpClient() + ", baseUrl=" + this.getBaseUrl() + ", path=" + this.getPath() + ", queryParams=" + this.getQueryParams() + ")";
    }

    public OkHttpWebTarget withOkHttpClient(OkHttpClient okHttpClient) {
        return this.okHttpClient == okHttpClient ? this : new OkHttpWebTarget(okHttpClient, this.baseUrl, this.path, this.queryParams);
    }

    public OkHttpWebTarget withBaseUrl(HttpUrl baseUrl) {
        return this.baseUrl == baseUrl ? this : new OkHttpWebTarget(this.okHttpClient, baseUrl, this.path, this.queryParams);
    }

    public OkHttpWebTarget withPath(ImmutableList<String> path) {
        return this.path == path ? this : new OkHttpWebTarget(this.okHttpClient, this.baseUrl, path, this.queryParams);
    }

    public OkHttpWebTarget withQueryParams(SetMultimap<String, String> queryParams) {
        return this.queryParams == queryParams ? this : new OkHttpWebTarget(this.okHttpClient, this.baseUrl, this.path, queryParams);
    }
}

