/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient.transport.okhttp;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.SocketFactory;
import org.testcontainers.shaded.org.scalasbt.ipcsocket.UnixDomainSocket;

public final class UnixSocketFactory
extends SocketFactory {
    private final String socketPath;

    @Override
    public Socket createSocket() {
        return new UnixDomainSocket(this.socketPath){

            @Override
            public void connect(SocketAddress endpoint, int timeout) throws IOException {
            }

            @Override
            public InputStream getInputStream() {
                return new FilterInputStream(super.getInputStream()){

                    @Override
                    public void close() throws IOException {
                        this.shutdownInput();
                    }
                };
            }

            @Override
            public OutputStream getOutputStream() {
                return new FilterOutputStream(super.getOutputStream()){

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.out.write(b, off, len);
                    }

                    @Override
                    public void close() throws IOException {
                        this.shutdownOutput();
                    }
                };
            }
        };
    }

    @Override
    public Socket createSocket(String s, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
        throw new UnsupportedOperationException();
    }

    public UnixSocketFactory(String socketPath) {
        this.socketPath = socketPath;
    }

    public String getSocketPath() {
        return this.socketPath;
    }

    public String toString() {
        return "UnixSocketFactory(socketPath=" + this.getSocketPath() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnixSocketFactory)) {
            return false;
        }
        UnixSocketFactory other = (UnixSocketFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$socketPath = this.getSocketPath();
        String other$socketPath = other.getSocketPath();
        return !(this$socketPath == null ? other$socketPath != null : !this$socketPath.equals(other$socketPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnixSocketFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $socketPath = this.getSocketPath();
        result = result * 59 + ($socketPath == null ? 43 : $socketPath.hashCode());
        return result;
    }
}

