/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.model.Image;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.images.TimeLimitedLoggedPullImageResultCallback;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.LazyFuture;

public class RemoteDockerImage
extends LazyFuture<String> {
    @Deprecated
    public static final Set<DockerImageName> AVAILABLE_IMAGE_NAME_CACHE = new HashSet<DockerImageName>();
    private static final Duration PULL_RETRY_TIME_LIMIT = Duration.ofMinutes(2L);
    private DockerImageName imageName;

    public RemoteDockerImage(String dockerImageName) {
        this.imageName = new DockerImageName(dockerImageName);
    }

    public RemoteDockerImage(@NonNull String repository, @NonNull String tag) {
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.imageName = new DockerImageName(repository, tag);
    }

    @Override
    protected final String resolve() {
        Logger logger = DockerLoggerFactory.getLogger(this.imageName.toString());
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try {
            if (AVAILABLE_IMAGE_NAME_CACHE.contains(this.imageName)) {
                logger.trace("{} is already in image name cache", (Object)this.imageName);
                return this.imageName.toString();
            }
            ListImagesCmd listImagesCmd = dockerClient.listImagesCmd();
            if (Boolean.parseBoolean(System.getProperty("useFilter"))) {
                listImagesCmd = listImagesCmd.withImageNameFilter(this.imageName.toString());
            }
            List updatedImages = (List)listImagesCmd.exec();
            updatedImages.stream().map(Image::getRepoTags).filter(Objects::nonNull).flatMap(Stream::of).map(DockerImageName::new).collect(Collectors.toCollection(() -> AVAILABLE_IMAGE_NAME_CACHE));
            if (AVAILABLE_IMAGE_NAME_CACHE.contains(this.imageName)) {
                logger.trace("{} is in image name cache following listing of images", (Object)this.imageName);
                return this.imageName.toString();
            }
            logger.info("Pulling docker image: {}. Please be patient; this may take some time but only needs to be done once.", (Object)this.imageName);
            Exception lastFailure = null;
            Instant lastRetryAllowed = Instant.now().plus(PULL_RETRY_TIME_LIMIT);
            while (Instant.now().isBefore(lastRetryAllowed)) {
                try {
                    TimeLimitedLoggedPullImageResultCallback callback = new TimeLimitedLoggedPullImageResultCallback(logger);
                    dockerClient.pullImageCmd(this.imageName.getUnversionedPart()).withTag(this.imageName.getVersionPart()).exec(callback);
                    callback.awaitCompletion();
                    AVAILABLE_IMAGE_NAME_CACHE.add(this.imageName);
                    return this.imageName.toString();
                }
                catch (InternalServerErrorException | InterruptedException e) {
                    lastFailure = e;
                    logger.warn("Retrying pull for image: {} ({}s remaining)", (Object)this.imageName, (Object)Duration.between(Instant.now(), lastRetryAllowed).getSeconds());
                }
            }
            logger.error("Failed to pull image: {}. Please check output of `docker pull {}`", new Object[]{this.imageName, this.imageName, lastFailure});
            throw new ContainerFetchException("Failed to pull image: " + this.imageName, lastFailure);
        }
        catch (DockerClientException e) {
            throw new ContainerFetchException("Failed to get Docker client for " + this.imageName, e);
        }
    }

    public String toString() {
        return "RemoteDockerImage(imageName=" + this.imageName + ")";
    }
}

