/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.lifecycle;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.testcontainers.lifecycle.Startable;

public final class Startables {
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicLong COUNTER = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "testcontainers-lifecycle-" + this.COUNTER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    public static CompletableFuture<Void> deepStart(Collection<Startable> startables) {
        return Startables.deepStart(startables.stream());
    }

    public static CompletableFuture<Void> deepStart(Stream<Startable> startables) {
        return Startables.deepStart(new HashMap<Startable, CompletableFuture<Void>>(), startables);
    }

    private static CompletableFuture<Void> deepStart(Map<Startable, CompletableFuture<Void>> started, Stream<Startable> startables) {
        CompletableFuture[] futures = (CompletableFuture[])startables.map(it -> {
            HashMap subStarted = new HashMap(started);
            CompletableFuture future = started.computeIfAbsent((Startable)it, startable -> Startables.deepStart(subStarted, startable.getDependencies().stream()).thenRunAsync(startable::start, EXECUTOR));
            started.putAll(subStarted);
            return future;
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures);
    }

    private Startables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

