/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.scalasbt.ipcsocket;

import com.sun.jna.LastErrorException;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.testcontainers.shaded.org.scalasbt.ipcsocket.UnixDomainSocket;
import org.testcontainers.shaded.org.scalasbt.ipcsocket.UnixDomainSocketLibrary;

public class UnixDomainServerSocket
extends ServerSocket {
    private static final int DEFAULT_BACKLOG = 50;
    private final AtomicInteger fd;
    private final int backlog;
    private boolean isBound;
    private boolean isClosed;

    public UnixDomainServerSocket() throws IOException {
        this(50, null);
    }

    public UnixDomainServerSocket(int n) throws IOException {
        this(n, null);
    }

    public UnixDomainServerSocket(String string) throws IOException {
        this(50, string);
    }

    public UnixDomainServerSocket(int n, String string) throws IOException {
        try {
            this.fd = new AtomicInteger(UnixDomainSocketLibrary.socket(1, 1, 0));
            this.backlog = n;
            if (string != null) {
                this.bind(new UnixDomainServerSocketAddress(string));
            }
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    @Override
    public synchronized void bind(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof UnixDomainServerSocketAddress)) {
            throw new IllegalArgumentException("endpoint must be an instance of UnixDomainServerSocketAddress");
        }
        if (this.isBound) {
            throw new IllegalStateException("Socket is already bound");
        }
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        UnixDomainServerSocketAddress unixDomainServerSocketAddress = (UnixDomainServerSocketAddress)socketAddress;
        UnixDomainSocketLibrary.SockaddrUn sockaddrUn = new UnixDomainSocketLibrary.SockaddrUn(unixDomainServerSocketAddress.getPath());
        try {
            int n = this.fd.get();
            UnixDomainSocketLibrary.bind(n, sockaddrUn, sockaddrUn.size());
            UnixDomainSocketLibrary.listen(n, this.backlog);
            this.isBound = true;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket accept() throws IOException {
        Object object = this;
        synchronized (object) {
            if (!this.isBound) {
                throw new IllegalStateException("Socket is not bound");
            }
            if (this.isClosed) {
                throw new IllegalStateException("Socket is already closed");
            }
        }
        try {
            object = new UnixDomainSocketLibrary.SockaddrUn();
            IntByReference intByReference = new IntByReference();
            intByReference.setValue(object.size());
            int n = UnixDomainSocketLibrary.accept(this.fd.get(), (UnixDomainSocketLibrary.SockaddrUn)((Object)object), intByReference);
            return new UnixDomainSocket(n);
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Socket is already closed");
        }
        try {
            UnixDomainSocketLibrary.close(this.fd.getAndSet(-1));
            this.isClosed = true;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException(lastErrorException);
        }
    }

    public static class UnixDomainServerSocketAddress
    extends SocketAddress {
        private final String path;

        public UnixDomainServerSocketAddress(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }
    }
}

