/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.zeroturnaround.exec.listener;

import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.zeroturnaround.exec.listener.ProcessDestroyer;

public class ShutdownHookProcessDestroyer
implements ProcessDestroyer,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(ShutdownHookProcessDestroyer.class);
    public static final ProcessDestroyer INSTANCE = new ShutdownHookProcessDestroyer();
    private final Vector<Process> processes = new Vector();
    private ProcessDestroyerImpl destroyProcessThread = null;
    private boolean added = false;
    private volatile boolean shutDownHookExecuted = false;
    private volatile boolean running = false;

    private void addShutdownHook() {
        if (!this.running) {
            this.destroyProcessThread = new ProcessDestroyerImpl();
            Runtime.getRuntime().addShutdownHook(this.destroyProcessThread);
            this.added = true;
        }
    }

    private void removeShutdownHook() {
        if (this.added && !this.running) {
            boolean removed = Runtime.getRuntime().removeShutdownHook(this.destroyProcessThread);
            if (!removed) {
                log.error("Could not remove shutdown hook");
            }
            this.destroyProcessThread.setShouldDestroy(false);
            this.destroyProcessThread.start();
            try {
                this.destroyProcessThread.join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.destroyProcessThread = null;
            this.added = false;
        }
    }

    public boolean isAddedAsShutdownHook() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            if (this.processes.size() == 0) {
                try {
                    if (this.shutDownHookExecuted) {
                        throw new IllegalStateException();
                    }
                    this.addShutdownHook();
                }
                catch (IllegalStateException e) {
                    this.destroy(process);
                }
            }
            this.processes.addElement(process);
            return this.processes.contains(process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Process process) {
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            boolean processRemoved = this.processes.removeElement(process);
            if (processRemoved && this.processes.size() == 0) {
                try {
                    this.removeShutdownHook();
                }
                catch (IllegalStateException e) {
                    this.shutDownHookExecuted = true;
                }
            }
            return processRemoved;
        }
    }

    public int size() {
        return this.processes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.shutDownHookExecuted) {
            return;
        }
        Vector<Process> vector = this.processes;
        synchronized (vector) {
            this.running = true;
            Enumeration<Process> e = this.processes.elements();
            while (e.hasMoreElements()) {
                this.destroy(e.nextElement());
            }
            this.processes.clear();
            this.shutDownHookExecuted = true;
        }
    }

    private void destroy(Process process) {
        try {
            process.destroy();
        }
        catch (Throwable t) {
            log.error("Unable to terminate process during process shutdown");
        }
    }

    private class ProcessDestroyerImpl
    extends Thread {
        private boolean shouldDestroy;

        public ProcessDestroyerImpl() {
            super("ProcessDestroyer Shutdown Hook");
            this.shouldDestroy = true;
        }

        public void run() {
            if (this.shouldDestroy) {
                ShutdownHookProcessDestroyer.this.run();
            }
        }

        public void setShouldDestroy(boolean shouldDestroy) {
            this.shouldDestroy = shouldDestroy;
        }
    }
}

