/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.org.apache.commons.lang.SystemUtils;
import org.testcontainers.utility.CommandLine;

public class DockerMachineClient {
    private static DockerMachineClient instance;
    private static final Logger LOGGER;
    private static final String executableName;

    private DockerMachineClient() {
    }

    public static synchronized DockerMachineClient instance() {
        if (instance == null) {
            instance = new DockerMachineClient();
        }
        return instance;
    }

    public boolean isInstalled() {
        return CommandLine.executableExists(executableName);
    }

    public Optional<String> getDefaultMachine() {
        String envMachineName;
        String ls = CommandLine.runShellCommand(executableName, "ls", "-q");
        List<String> machineNames = Arrays.asList(ls.split("\n"));
        if (machineNames.contains(envMachineName = System.getenv("DOCKER_MACHINE_NAME"))) {
            LOGGER.debug("Using docker-machine set in DOCKER_MACHINE_NAME: {}", (Object)envMachineName);
            return Optional.of(envMachineName);
        }
        if (machineNames.contains("default")) {
            LOGGER.debug("DOCKER_MACHINE_NAME is not set; Using 'default' docker-machine", (Object)envMachineName);
            return Optional.of("default");
        }
        if (machineNames.size() > 0) {
            LOGGER.debug("DOCKER_MACHINE_NAME is not set and no machine named 'default' found; Using first machine found with `docker-machine ls`: {}", (Object)machineNames.get(0));
            return Optional.of(machineNames.get(0));
        }
        return Optional.empty();
    }

    public void ensureMachineRunning(@NonNull String machineName) {
        if (machineName == null) {
            throw new NullPointerException("machineName is marked non-null but is null");
        }
        if (!this.isMachineRunning(machineName)) {
            LOGGER.info("Docker-machine '{}' is not running. Will start it now", (Object)machineName);
            CommandLine.runShellCommand("docker-machine", "start", machineName);
        }
    }

    public String getDockerDaemonIpAddress(@NonNull String machineName) {
        if (machineName == null) {
            throw new NullPointerException("machineName is marked non-null but is null");
        }
        return CommandLine.runShellCommand(executableName, "ip", machineName);
    }

    public boolean isMachineRunning(String machineName) {
        String status = CommandLine.runShellCommand("docker-machine", "status", machineName);
        return status.trim().equalsIgnoreCase("running");
    }

    public boolean isDefaultMachineRunning() {
        return this.isMachineRunning(this.getDefaultMachine().orElse("default"));
    }

    static {
        LOGGER = LoggerFactory.getLogger(DockerMachineClient.class);
        executableName = SystemUtils.IS_OS_WINDOWS ? "docker-machine.exe" : "docker-machine";
    }
}

