/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestcontainersConfiguration {
    private static final Logger log = LoggerFactory.getLogger(TestcontainersConfiguration.class);
    private final Object $lock = new Object[0];
    private static String PROPERTIES_FILE_NAME = "testcontainers.properties";
    private static File ENVIRONMENT_CONFIG_FILE = new File(System.getProperty("user.home"), "." + PROPERTIES_FILE_NAME);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Properties environmentProperties;
    private final Properties properties = new Properties();

    TestcontainersConfiguration(Properties environmentProperties, Properties classpathProperties) {
        this.environmentProperties = environmentProperties;
        this.properties.putAll((Map<?, ?>)classpathProperties);
        this.properties.putAll((Map<?, ?>)environmentProperties);
    }

    public String getAmbassadorContainerImage() {
        return (String)this.properties.getOrDefault((Object)"ambassador.container.image", "richnorth/ambassador:latest");
    }

    public String getSocatContainerImage() {
        return (String)this.properties.getOrDefault((Object)"socat.container.image", "alpine/socat:latest");
    }

    public String getVncRecordedContainerImage() {
        return (String)this.properties.getOrDefault((Object)"vncrecorder.container.image", "quay.io/testcontainers/vnc-recorder:1.1.0");
    }

    public String getDockerComposeContainerImage() {
        return (String)this.properties.getOrDefault((Object)"compose.container.image", "docker/compose:1.8.0");
    }

    public String getTinyImage() {
        return (String)this.properties.getOrDefault((Object)"tinyimage.container.image", "alpine:3.5");
    }

    public boolean isRyukPrivileged() {
        return Boolean.parseBoolean((String)this.properties.getOrDefault((Object)"ryuk.container.privileged", "false"));
    }

    public String getRyukImage() {
        return (String)this.properties.getOrDefault((Object)"ryuk.container.image", "quay.io/testcontainers/ryuk:0.2.3");
    }

    public String getSSHdImage() {
        return (String)this.properties.getOrDefault((Object)"sshd.container.image", "quay.io/testcontainers/sshd:1.0.0");
    }

    public Integer getRyukTimeout() {
        return Integer.parseInt((String)this.properties.getOrDefault((Object)"ryuk.container.timeout", "30"));
    }

    public String getKafkaImage() {
        return (String)this.properties.getOrDefault((Object)"kafka.container.image", "confluentinc/cp-kafka");
    }

    public String getPulsarImage() {
        return (String)this.properties.getOrDefault((Object)"pulsar.container.image", "apachepulsar/pulsar");
    }

    public boolean isDisableChecks() {
        return Boolean.parseBoolean((String)this.environmentProperties.getOrDefault((Object)"checks.disable", "false"));
    }

    public String getDockerClientStrategyClassName() {
        return (String)this.environmentProperties.get("docker.client.strategy");
    }

    @Deprecated
    public String getTransportType() {
        return this.properties.getProperty("transport.type", "okhttp");
    }

    public Integer getImagePullPauseTimeout() {
        return Integer.parseInt((String)this.properties.getOrDefault((Object)"pull.pause.timeout", "30"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGlobalConfig(@NonNull String prop, @NonNull String value) {
        Object object = this.$lock;
        synchronized (object) {
            if (prop == null) {
                throw new NullPointerException("prop is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            try {
                if (value.equals(this.environmentProperties.get(prop))) {
                    return false;
                }
                this.environmentProperties.setProperty(prop, value);
                ENVIRONMENT_CONFIG_FILE.createNewFile();
                try (FileOutputStream outputStream = new FileOutputStream(ENVIRONMENT_CONFIG_FILE);){
                    this.environmentProperties.store(outputStream, "Modified by Testcontainers");
                }
                this.properties.setProperty(prop, value);
                return true;
            }
            catch (Exception e) {
                log.debug("Can't store environment property {} in {}", (Object)prop, (Object)ENVIRONMENT_CONFIG_FILE);
                return false;
            }
        }
    }

    private static TestcontainersConfiguration loadConfiguration() {
        return new TestcontainersConfiguration(TestcontainersConfiguration.readProperties(ENVIRONMENT_CONFIG_FILE.toURI().toURL()), Stream.of(TestcontainersConfiguration.class.getClassLoader(), Thread.currentThread().getContextClassLoader()).map(it -> it.getResource(PROPERTIES_FILE_NAME)).filter(Objects::nonNull).map(TestcontainersConfiguration::readProperties).reduce(new Properties(), (a, b) -> {
            a.putAll((Map<?, ?>)b);
            return a;
        }));
    }

    private static Properties readProperties(URL url) {
        log.debug("Testcontainers configuration overrides will be loaded from {}", (Object)url);
        Properties properties = new Properties();
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            log.trace("Testcontainers config override was found on {} but the file was not found", (Object)url, (Object)e);
        }
        catch (IOException e) {
            log.warn("Testcontainers config override was found on {} but could not be loaded", (Object)url, (Object)e);
        }
        return properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestcontainersConfiguration)) {
            return false;
        }
        TestcontainersConfiguration other = (TestcontainersConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Properties this$environmentProperties = this.environmentProperties;
        Properties other$environmentProperties = other.environmentProperties;
        if (this$environmentProperties == null ? other$environmentProperties != null : !((Object)this$environmentProperties).equals(other$environmentProperties)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TestcontainersConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $environmentProperties = this.environmentProperties;
        result = result * 59 + ($environmentProperties == null ? 43 : ((Object)$environmentProperties).hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "TestcontainersConfiguration(environmentProperties=" + this.environmentProperties + ", properties=" + this.getProperties() + ")";
    }

    private TestcontainersConfiguration(Properties environmentProperties) {
        this.environmentProperties = environmentProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestcontainersConfiguration getInstance() {
        Object value = instance.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                value = instance.get();
                if (value == null) {
                    TestcontainersConfiguration actualValue = TestcontainersConfiguration.loadConfiguration();
                    value = actualValue == null ? instance : actualValue;
                    instance.set(value);
                }
            }
        }
        return (TestcontainersConfiguration)(value == instance ? null : value);
    }
}

