/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Maps;
import org.testng.internal.XmlMethodSelector;

public class ClassMethodMap {
    private final Map<Object, Collection<ITestNGMethod>> classMap = Maps.newConcurrentMap();
    private final Map<ITestClass, Set<Object>> beforeClassMethods = Maps.newConcurrentMap();
    private final Map<ITestClass, Set<Object>> afterClassMethods = Maps.newConcurrentMap();

    public ClassMethodMap(List<ITestNGMethod> list, XmlMethodSelector xmlMethodSelector) {
        for (ITestNGMethod iTestNGMethod : list) {
            if (xmlMethodSelector != null && !xmlMethodSelector.includeMethod(null, iTestNGMethod, true)) continue;
            Object object = iTestNGMethod.getInstance();
            Collection<ITestNGMethod> collection = this.classMap.get(object);
            if (collection == null) {
                collection = new ConcurrentLinkedQueue<ITestNGMethod>();
                this.classMap.put(object, collection);
            }
            collection.add(iTestNGMethod);
        }
    }

    public boolean removeAndCheckIfLast(ITestNGMethod iTestNGMethod, Object object) {
        Collection<ITestNGMethod> collection = this.classMap.get(object);
        if (collection == null) {
            throw new AssertionError((Object)"l should not be null");
        }
        collection.remove(iTestNGMethod);
        for (ITestNGMethod iTestNGMethod2 : collection) {
            if (!iTestNGMethod2.getEnabled() || !iTestNGMethod2.getTestClass().equals(iTestNGMethod.getTestClass())) continue;
            return false;
        }
        return true;
    }

    public Map<ITestClass, Set<Object>> getInvokedBeforeClassMethods() {
        return this.beforeClassMethods;
    }

    public Map<ITestClass, Set<Object>> getInvokedAfterClassMethods() {
        return this.afterClassMethods;
    }

    public void clear() {
        for (Set<Object> set : this.beforeClassMethods.values()) {
            set.clear();
        }
        for (Set<Object> set : this.afterClassMethods.values()) {
            set.clear();
        }
        this.beforeClassMethods.clear();
        this.afterClassMethods.clear();
    }
}

