/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.testng.IClass;
import org.testng.IModuleFactory;
import org.testng.ITestContext;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassImpl;
import org.testng.internal.InstanceCreator;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;

public class GuiceHelper {
    private final ITestContext context;

    GuiceHelper(ITestContext iTestContext) {
        this.context = iTestContext;
    }

    Injector getInjector(IClass iClass) {
        Injector injector;
        Guice guice = (Guice)AnnotationHelper.findAnnotationSuperClasses(Guice.class, iClass.getRealClass());
        if (guice == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Injector injector2 = ((ClassImpl)iClass).getParentInjector();
        List list = Lists.newArrayList(this.getModules(guice, injector2, iClass.getRealClass()));
        List list2 = Lists.newArrayList((Collection)list);
        Module module = GuiceHelper.getParentModule(this.context);
        if (module != null) {
            list.add(module);
        }
        if ((injector = this.context.getInjector(list2)) == null) {
            injector = GuiceHelper.createInjector(this.context, list);
            this.context.addInjector(list, injector);
        }
        return injector;
    }

    private static Module getParentModule(ITestContext iTestContext) {
        if (Utils.isStringEmpty(iTestContext.getSuite().getParentModule())) {
            return null;
        }
        Class<?> clazz = ClassHelper.forName(iTestContext.getSuite().getParentModule());
        if (clazz == null) {
            throw new TestNGException("Cannot load parent Guice module class: " + iTestContext.getSuite().getParentModule());
        }
        if (!Module.class.isAssignableFrom(clazz)) {
            throw new TestNGException("Provided class is not a Guice module: " + clazz.getName());
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(ITestContext.class);
            return (Module)InstanceCreator.newInstance(constructor, (Object[])new Object[]{iTestContext});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (Module)InstanceCreator.newInstance(clazz);
        }
    }

    public static Injector createInjector(ITestContext iTestContext, List<Module> list) {
        Module module = GuiceHelper.getParentModule(iTestContext);
        List list2 = Lists.newArrayList(list);
        if (module != null) {
            list2.add(module);
        }
        Stage stage = Stage.DEVELOPMENT;
        String string = iTestContext.getSuite().getGuiceStage();
        if (Utils.isStringNotEmpty(string)) {
            stage = Stage.valueOf((String)string);
        }
        return com.google.inject.Guice.createInjector((Stage)stage, (Iterable)list2);
    }

    private List<Module> getModules(Guice guice, Injector injector, Class<?> clazz) {
        IModuleFactory iModuleFactory;
        Module module;
        List list = Lists.newArrayList();
        for (Class<? extends Module> clazz2 : guice.modules()) {
            List<Module> list2 = this.context.getGuiceModules(clazz2);
            if (list2 != null && !list2.isEmpty()) {
                list.addAll(list2);
                continue;
            }
            Module module2 = (Module)injector.getInstance(clazz2);
            list.add(module2);
            this.context.getGuiceModules(clazz2).add(module2);
        }
        Class<? extends IModuleFactory> clazz3 = guice.moduleFactory();
        if (clazz3 != IModuleFactory.class && (module = (iModuleFactory = (IModuleFactory)injector.getInstance(clazz3)).createModule(this.context, clazz)) != null) {
            list.add(module);
        }
        return list;
    }
}

